<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Element Description: VC Gallery
 */
if (class_exists('WPBakeryShortCode')) {
    /**
     * Class WpmfBakeryGalleryAddon
     */
    class WpmfBakeryGalleryAddon extends WPBakeryShortCode
    {
        /**
         * WpmfBakeryGalleryAddon constructor.
         *
         * @return void
         */
        function __construct() // phpcs:ignore Squiz.Scope.MethodScope.Missing -- Method extends from WPBakeryShortCode class
        {
            // Stop all if VC is not enabled
            if (!defined('WPB_VC_VERSION')) {
                return;
            }

            $settings = get_option('wpmf_gallery_settings');
            $galleries = get_categories(
                array(
                    'hide_empty' => false,
                    'taxonomy' => WPMF_GALLERY_ADDON_TAXO,
                    'pll_get_terms_not_translated' => 1
                )
            );

            $galleries = wpmfParentSort($galleries);
            $galleries_list = array();
            $label = esc_html__('Select a gallery', 'wp-media-folder-gallery-addon');
            $galleries_list[$label] = 0;
            foreach ($galleries as $gallery) {
                $label = str_repeat('--', $gallery->depth) . $gallery->name;
                $galleries_list[$label] = $gallery->term_id;
            }

            // Map the block with vc_map()
            vc_map(
                array(
                    'name' => esc_html__('WPMF Gallery Addon', 'wp-media-folder-gallery-addon'),
                    'description' => esc_html__('Responsive image gallery with themes', 'wp-media-folder-gallery-addon'),
                    'base' => 'vc_wpmf_gallery_addon',
                    'category' => 'JoomUnited',
                    'icon' => WPMF_PLUGIN_URL . '/assets/images/gallery_addon-bakery.svg',
                    'front_enqueue_js' => array(
                        WPMF_PLUGIN_URL . '/assets/js/display-gallery/flexslider/jquery.flexslider.js',
                        WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/js/jquery.flipster.js',
                        WPMF_PLUGIN_URL . '/assets/js/vc_front.js'
                    ),
                    'front_enqueue_css' => array(
                        WPMF_PLUGIN_URL . '/assets/css/display-gallery/flexslider.css',
                        WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/css/jquery.flipster.css',
                        WPMF_PLUGIN_URL . '/assets/css/display-gallery/style-display-gallery.css',
                    ),
                    'params' => array(
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Choose a Gallery', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'gallery_id',
                            'class' => 'wpmf_vc_dropdown',
                            'value' => $galleries_list,
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Theme', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'theme',
                            'class' => 'wpmf_vc_dropdown',
                            'value' => array(
                                esc_html__('Default', 'wp-media-folder-gallery-addon') => 'default',
                                esc_html__('Masonry', 'wp-media-folder-gallery-addon') => 'masonry',
                                esc_html__('Portfolio', 'wp-media-folder-gallery-addon') => 'portfolio',
                                esc_html__('Slider', 'wp-media-folder-gallery-addon') => 'slider',
                                esc_html__('Flow slide', 'wp-media-folder-gallery-addon') => 'flowslide',
                                esc_html__('Square grid', 'wp-media-folder-gallery-addon') => 'square_grid',
                                esc_html__('Material', 'wp-media-folder-gallery-addon') => 'material'
                            ),
                            'std' => 'masonry',
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Columns', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'columns',
                            'value' => $settings['theme']['masonry_theme']['columns'],
                            'min' => 1,
                            'max' => 8,
                            'step' => 1,
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Gutter', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'gutterwidth',
                            'value' => 5,
                            'min' => 0,
                            'max' => 50,
                            'step' => 5,
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Image size', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'size',
                            'value' => $settings['theme']['masonry_theme']['size'],
                            'description' => esc_html__('Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "medium" size.', 'wp-media-folder-gallery-addon'),
                            'dependency' => array(
                                'element' => 'source',
                                'value' => 'media_library',
                            ),
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Action On Click', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'link',
                            'class' => 'wpmf_vc_dropdown',
                            'std' => $settings['theme']['masonry_theme']['link'],
                            'value' => array(
                                esc_html__('Lightbox', 'wp-media-folder-gallery-addon') => 'file',
                                esc_html__('Attachment Page', 'wp-media-folder-gallery-addon') => 'post',
                                esc_html__('None', 'wp-media-folder-gallery-addon') => 'none'
                            ),
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'textfield',
                            'heading' => esc_html__('Lightbox size', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'targetsize',
                            'value' => $settings['theme']['masonry_theme']['targetsize'],
                            'description' => esc_html__('Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use "large" size.', 'wp-media-folder-gallery-addon'),
                            'dependency' => array(
                                'element' => 'source',
                                'value' => 'media_library',
                            ),
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Order by', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'orderby',
                            'class' => 'wpmf_vc_dropdown',
                            'std' => $settings['theme']['masonry_theme']['orderby'],
                            'value' => array(
                                esc_html__('Custom', 'wp-media-folder-gallery-addon') => 'post__in',
                                esc_html__('Random', 'wp-media-folder-gallery-addon') => 'rand',
                                esc_html__('Title', 'wp-media-folder-gallery-addon') => 'title',
                                esc_html__('Date', 'wp-media-folder-gallery-addon') => 'date'
                            ),
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Order', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'order',
                            'class' => 'wpmf_vc_dropdown',
                            'std' => $settings['theme']['masonry_theme']['order'],
                            'value' => array(
                                esc_html__('Ascending', 'wp-media-folder-gallery-addon') => 'ASC',
                                esc_html__('Descending', 'wp-media-folder-gallery-addon') => 'DESC'
                            ),
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('General', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Border Radius', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'border_radius',
                            'value' => 0,
                            'min' => 0,
                            'max' => 20,
                            'step' => 1,
                            'group' => esc_html__('Border', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Border Width', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'border_width',
                            'value' => 0,
                            'min' => 0,
                            'max' => 30,
                            'step' => 1,
                            'group' => esc_html__('Border', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__('Border Type', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'border_style',
                            'class' => 'wpmf_vc_dropdown',
                            'std' => 'solid',
                            'value' => array(
                                esc_html__('Solid', 'wp-media-folder-gallery-addon') => 'solid',
                                esc_html__('Double', 'wp-media-folder-gallery-addon') => 'double',
                                esc_html__('Dotted', 'wp-media-folder-gallery-addon') => 'dotted',
                                esc_html__('Dashed', 'wp-media-folder-gallery-addon') => 'dashed',
                                esc_html__('Groove', 'wp-media-folder-gallery-addon') => 'groove'
                            ),
                            'group' => esc_html__('Border', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Border Color', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'border_color',
                            'edit_field_class' => 'vc_col-sm-6',
                            'std' => '#cccccc',
                            'group' => esc_html__('Border', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'checkbox',
                            'heading' => esc_html__('Enable', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'enable_shadow',
                            'value' => array(esc_html__('Yes', 'wp-media-folder-gallery-addon') => 'yes'),
                            'group' => esc_html__('Shadow', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Horizontal', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'shadow_horizontal',
                            'value' => 0,
                            'min' => -50,
                            'max' => 50,
                            'step' => 1,
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('Shadow', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Vertical', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'shadow_vertical',
                            'value' => 0,
                            'min' => -50,
                            'max' => 50,
                            'step' => 1,
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('Shadow', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Blur', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'shadow_blur',
                            'value' => 0,
                            'min' => 0,
                            'max' => 50,
                            'step' => 1,
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('Shadow', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'wpmf_number',
                            'heading' => esc_html__('Spread', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'shadow_spread',
                            'value' => 0,
                            'min' => 0,
                            'max' => 50,
                            'step' => 1,
                            'edit_field_class' => 'vc_col-sm-6',
                            'group' => esc_html__('Shadow', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'colorpicker',
                            'heading' => esc_html__('Shadow Color', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'shadow_color',
                            'edit_field_class' => 'vc_col-sm-6',
                            'std' => '#cccccc',
                            'group' => esc_html__('Shadow', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'checkbox',
                            'heading' => esc_html__('Enable Gallery Navigation', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'gallery_navigation',
                            'value' => array(esc_html__('Yes', 'wp-media-folder-gallery-addon') => 'yes'),
                            'group' => esc_html__('Advanced', 'wp-media-folder-gallery-addon')
                        ),
                        array(
                            'type' => 'checkbox',
                            'heading' => esc_html__('Enable Images Tags', 'wp-media-folder-gallery-addon'),
                            'param_name' => 'gallery_image_tags',
                            'value' => array(esc_html__('Yes', 'wp-media-folder-gallery-addon') => 'yes'),
                            'group' => esc_html__('Advanced', 'wp-media-folder-gallery-addon')
                        ),
                    )
                )
            );
            add_shortcode('vc_wpmf_gallery_addon', array($this, 'vcWpmfGalleryHtml'));
        }

        /**
         * Render html
         *
         * @param array $atts Param details
         *
         * @return string
         */
        public function vcWpmfGalleryHtml($atts)
        {
            if (empty($atts['gallery_id'])) {
                $html = '<div class="wpmf-vc-container">
            <div id="vc-gallery-addon-placeholder" class="vc-gallery-addon-placeholder">
                        <span class="wpmf-vc-message">
                            ' . esc_html__('Please select a gallery to activate the preview', 'wp-media-folder-gallery-addon') . '
                        </span>
            </div>
          </div>';
            } else {
                $gallery_id = (!empty($atts['gallery_id'])) ? $atts['gallery_id'] : 0;
                $gallery_navigation = (isset($atts['gallery_navigation']) && $atts['gallery_navigation'] === 'yes') ? 1 : 0;
                $gallery_image_tags = (isset($atts['gallery_image_tags']) && $atts['gallery_image_tags'] === 'yes') ? 1 : 0;
                $theme = (!empty($atts['theme'])) ? $atts['theme'] : 'masonry';
                $columns = (!empty($atts['columns'])) ? $atts['columns'] : 3;
                $size = (!empty($atts['size'])) ? $atts['size'] : 'medium';
                $targetsize = (!empty($atts['targetsize'])) ? $atts['targetsize'] : 'large';
                $link = (!empty($atts['link'])) ? $atts['link'] : 'file';
                $orderby = (!empty($atts['orderby'])) ? $atts['orderby'] : 'post__in';
                $order = (!empty($atts['order'])) ? $atts['order'] : 'ASC';
                $gutterwidth = (!empty($atts['gutterwidth'])) ? $atts['gutterwidth'] : 5;
                $border_radius = (!empty($atts['border_radius'])) ? $atts['border_radius'] : 0;
                $border_style = (!empty($atts['border_style'])) ? $atts['border_style'] : 'solid';
                $border_width = (!empty($atts['border_width'])) ? $atts['border_width'] : 0;
                $border_color = (!empty($atts['border_color'])) ? $atts['border_color'] : '#cccccc';
                $enable_shadow = (isset($atts['enable_shadow']) && $atts['enable_shadow'] === 'yes') ? true : false;
                $shadow_horizontal = (!empty($atts['shadow_horizontal'])) ? $atts['shadow_horizontal'] : 0;
                $shadow_vertical = (!empty($atts['shadow_vertical'])) ? $atts['shadow_vertical'] : 0;
                $shadow_blur = (!empty($atts['shadow_blur'])) ? $atts['shadow_blur'] : 0;
                $shadow_spread = (!empty($atts['shadow_spread'])) ? $atts['shadow_spread'] : 0;
                $shadow_color = (!empty($atts['shadow_color'])) ? $atts['shadow_color'] : '#cccccc';
                if ($enable_shadow) {
                    $img_shadow = $shadow_horizontal . 'px ' . $shadow_vertical . 'px ' . $shadow_blur . 'px ' . $shadow_spread . 'px ' . $shadow_color;
                } else {
                    $img_shadow = '';
                }

                // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
                if (isset($_REQUEST['vc_editable'])) {
                    $html = do_shortcode('[wpmfgallery display_tree="' . esc_attr($gallery_navigation) . '" display_tag="' . esc_attr($gallery_image_tags) . '" is_lazy_load="0" gallery_id="'. esc_attr($gallery_id) .'" display="' . esc_attr($theme) . '" columns="' . esc_attr($columns) . '" size="' . esc_attr($size) . '" targetsize="' . esc_attr($targetsize) . '" link="none" wpmf_orderby="' . esc_attr($orderby) . '" wpmf_order="' . esc_attr($order) . '" gutterwidth="' . esc_attr($gutterwidth) . '" img_border_radius="' . esc_attr($border_radius) . '" border_width="' . esc_attr($border_width) . '" border_style="' . esc_attr($border_style) . '" border_color="' . esc_attr($border_color) . '" img_shadow="' . esc_attr($img_shadow) . '"]');
                } else {
                    $html = do_shortcode('[wpmfgallery display_tree="' . esc_attr($gallery_navigation) . '" display_tag="' . esc_attr($gallery_image_tags) . '" is_lazy_load="1" gallery_id="'. esc_attr($gallery_id) .'" display="' . esc_attr($theme) . '" columns="' . esc_attr($columns) . '" size="' . esc_attr($size) . '" targetsize="' . esc_attr($targetsize) . '" link="' . esc_attr($link) . '" wpmf_orderby="' . esc_attr($orderby) . '" wpmf_order="' . esc_attr($order) . '" gutterwidth="' . esc_attr($gutterwidth) . '" img_border_radius="' . esc_attr($border_radius) . '" border_width="' . esc_attr($border_width) . '" border_style="' . esc_attr($border_style) . '" border_color="' . esc_attr($border_color) . '" img_shadow="' . esc_attr($img_shadow) . '"]');
                }
            }
            return $html;
        }
    }

    new WpmfBakeryGalleryAddon();
}
