<?php
/**
 * Custom meta fields | Fields
 *
 * @package Betheme
 * @author Muffin group
 * @link https://muffingroup.com
 */

if( ! defined( 'ABSPATH' ) ){
	exit; // Exit if accessed directly
}

if( ! class_exists('Mfn_Builder_Fields') )
{
  class Mfn_Builder_Fields {

		private $options;

    private $sliders;
    private $animations;

    private $section;
    private $wrap;
    private $items;

		private $tabs;
    private $itemtabs;
    private $advanced;

    private $vb;

    /**
      * Constructor
    */

    public function __construct( $vb = false ) {

    	$this->vb = $vb;

      $this->sliders = array(
        'layer' => Mfn_Builder_Helper::get_sliders('layer'),
        'rev' => Mfn_Builder_Helper::get_sliders('rev'),
      );

      $this->options = Mfn_Builder_Helper::get_options();

      $this->set_animations();
      $this->set_advanced();
      $this->set_section();
      $this->set_wrap();
      $this->set_items();

			if( !$this->vb ) $this->get_advanced();

    }

    /**
     * SET advanced fields
     */

    public function get_advanced( $vb = false ){

    	// items
    	$items_exclude = array('placeholder');

    	if( $vb ){
    		return $this->advanced;
    	}else{
    		foreach ($this->items as $i=>$it) {
	    		foreach($this->advanced as $adv){
	    			if( !in_array($i, $items_exclude) ){
	    				$this->items[$i]['fields'][] = $adv;
	    			}
	    		}
	    	}
    	}

    }

    /**
     * GET section fields
     */

    public function get_section(){

      return $this->section;

    }

    /**
     * GET wrap fields
     */

    public function get_wrap(){

      return $this->wrap;

    }

    /**
     * GET items
     */

    public function get_items(){

      return $this->items;

    }

    /**
     * GET item fields
     */

    public function get_item_fields( $item_type ){

      return $this->items[$item_type];

    }

		/**
		 * GET entrance animations
		 */

		public function get_animations(){

			return $this->animations;

		}

		/**
		 * GET placeholder image
		 */

		public function get_placeholder(){

			return get_theme_file_uri( '/muffin-options/svg/placeholders/image.svg' );

		}

		/**
		 * GET column editor
		 */

		public function get_column_editor(){

			$column_editor = 'textarea'; // codemirror

			if( $this->options['column-visual'] ){
				$column_editor = 'visual';
			}

			return $column_editor;

		}

    /**
     * SET section fields
   	 */

    private function set_section(){

  		$this->section = array(

  			/**
  			 * HEADER additional fields
  			 */

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
				),

				array(
					'class' => 'visible-header-builder',
					'title' => __('Header options', 'mfn-opts'),
				),

				array(
  				'id' => 'scroll-visibility',
  				'type' => 'switch',
  				'class' => 'visible-header-builder',
  				'title' => __('Scroll visibility', 'mfn-opts'),
  				'desc' => __('Sections hidden on the scroll should be at the top of the header. It takes effect with fixed type of Header', 'mfn-opts'),
  				'options' => array(
  					'show' => __('Default', 'mfn-opts'),
  					'hide' => __('Hide', 'mfn-opts'),
  				),
  				'std' => 'show'
  			),

				array(
  				'id' => 'closeable',
  				'attr_id' => 'closable-field',
  				'type' => 'switch',
  				'class' => 'visible-header-builder',
  				'title' => __('Closeable', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'closeable-time',
  				'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'text',
  				'class' => 'visible-header-builder narrow',
  				'title' => __('Show again after', 'mfn-opts'),
  				'desc' => __('How many days should it stay hidden after closing?', 'mfn-opts'),
  				'std' => '0',
  				'after' => 'days',
					'param' => 'number',
					'preview' => 'number',
  			),

  			array(
  				'id' => 'closeable-x',
  				'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'switch',
  				'title' => __('Close button position', 'mfn-opts'),
  				'std' => 'left',
  				'options' => array(
  					'left' => __('Left', 'mfn-opts'),
  					'right' => __('Right', 'mfn-opts'),
  				),
  			),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement .close-closeable-section .icon:color',
					'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
					'type' => 'color',
					'title' => __('Close icon color', 'mfn-opts'),
				),

  			array(
  				'id' => 'title',
  				'class' => 'hidden-header-builder',
  				'type' => 'text',
  				'title' => __('Title', 'mfn-opts'),
  				'desc' => __('Label in admin panel only', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
					'title' => __('Type', 'mfn-opts'),
				),

  			array(
  				'id' => 'type',
  				'attr_id' => 'section_type',
  				'class' => 'hidden-header-builder mfn-loop-switcher',
  				'type' => 'switch',
  				're_render' => true,
  				'title' => __('Type', 'mfn-opts'),
  				'desc' => __('Query loop displays section&apos;s content in designed loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'query' => __('Query loop', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			/* query type */

  			array(
  				'id' => 'query_type',
  				'attr_id' => 'query_type',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'section_type', 'opt' => 'is', 'val' => 'query' ),
  				'type' => 'select',
  				'title' => __('Query type', 'mfn-opts'),
  				'options' => array(
  					'' => __('Select', 'mfn-opts'),
  					'posts' => __('Posts', 'mfn-opts'),
  					'terms' => __('Terms', 'mfn-opts')
  				),
  				'std' => ''
  			),

  			/* posts query builder */

  			array(
  				'id' => 'query_post_type',
  				'attr_id' => 'query_post_type',
  				'class' => 'hidden-header-builder',
  				're_render' => true,
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Post type', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'post' => __('Post', 'mfn-opts'),
  					'page' => __('Page', 'mfn-opts'),
  					'portfolio' => __('Portfolio', 'mfn-opts'),
  					'offer' => __('Offer', 'mfn-opts'),
  					'client' => __('Clients', 'mfn-opts'),
  					'slide' => __('Slides', 'mfn-opts'),
  					'product' => __('Product', 'mfn-opts'),
  					'testimonial' => __('Testimonial', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
					'id' => 'query_post_type_testimonial',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'testimonial' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'options' => mfn_get_categories('testimonial-types'),
   				'js_hierarchical_options' => 'testimonial_types',
					'preview' => 'category',
				),

  			array(
					'id' => 'query_post_type_product',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'product' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_hierarchical_taxonomy('product_cat'),
					'js_hierarchical_options' => 'product_cat',
					'opt_append' => 'current',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_post',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'post' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('category'),
					'js_hierarchical_options' => 'blog_categories',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_portfolio',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'portfolio' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('portfolio-types'),
					'js_hierarchical_options' => 'portfolio_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_client',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'client' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('client-types'),
					'js_hierarchical_options' => 'client_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_offer',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'offer' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('offer-types'),
					'js_hierarchical_options' => 'offer_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_slide',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'slide' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('slide-types'),
					'js_hierarchical_options' => 'slide_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_product_order',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'product' ),
					're_render' => true,
					'type' => 'select',
					'title' => __('Display', 'mfn-opts'),
					'desc' => __('This option turns off standard order settings', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'on_sale' => __('On sale', 'mfn-opts'),
						'best_selling' => __('Best selling', 'mfn-opts'),
						'top_rated' => __('Top rated', 'mfn-opts'),
					),
					'std' => '',
				),

  			array(
  				'id' => 'query_post_orderby',
  				'class' => 'hidden-header-builder',
  				're_render' => true,
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'ID' => __('ID', 'mfn-opts'),
  					'date' => __('Date', 'mfn-opts'),
  					'modified' => __('Modified', 'mfn-opts'),
  					'title' => __('Title', 'mfn-opts'),
  					'rand' => __('Rand', 'mfn-opts'),
  				),
  				'std' => 'date'
  			),

  			array(
  				'id' => 'query_post_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'ASC'
  			),

  			array(
  				'id' => 'query_post_per_page',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			array(
  				'id' => 'query_post_offset',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Offset', 'mfn-opts'),
  				'desc' => __('This option omits provided quantity of posts (from the beginning)', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			/* terms query builder */

  			array(
  				'id' => 'query_terms_taxonomy',
  				'attr_id' => 'query_terms_taxonomy',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Taxonomy', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'category' => __('Post category', 'mfn-opts'),
  					'post_tag' => __('Post tag', 'mfn-opts'),
  					'portfolio_types' => __('Portfolio category', 'mfn-opts'),
  					'offer_types' => __('Offer category', 'mfn-opts'),
  					'testimonial_types' => __('Testimonial category', 'mfn-opts'),
  					'product_cat' => __('Product category', 'mfn-opts'),
  				),
  				'std' => 'category'
  			),

  			array(
  				'id' => 'query_terms_excludes_post_tag',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'post_tag' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('post_tag'),
   				'js_hierarchical_options' => 'blog_tags',
  			),

  			array(
  				'id' => 'query_terms_excludes_client_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'client_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('client-types'),
   				'js_hierarchical_options' => 'client_types',
  			),

  			array(
  				'id' => 'query_terms_excludes_portfolio_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'portfolio_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('portfolio-types'),
   				'js_hierarchical_options' => 'portfolio_types',
  			),

				array(
  				'id' => 'query_terms_excludes_category',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'category' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_get_categories('category'),
					'js_hierarchical_options' => 'blog_categories',
  			),

  			array(
  				'id' => 'query_terms_excludes_offer_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'offer_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('offer-types'),
   				'js_hierarchical_options' => 'offer_types',
  			),

  			array(
  				'id' => 'query_terms_excludes_testimonial_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'testimonial_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('testimonial-types'),
   				'js_hierarchical_options' => 'testimonial_types',
  			),

  			array(
  				'id' => 'query_terms_excludes_product_cat',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'product_cat' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_hierarchical_taxonomy('product_cat'),
					'js_hierarchical_options' => 'product_cat',
  			),

  			array(
  				'id' => 'query_terms_includes_post_tag',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'post_tag' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('post_tag'),
   				'js_hierarchical_options' => 'blog_tags',
  			),

  			array(
  				'id' => 'query_terms_includes_client_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'client_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('client-types'),
   				'js_hierarchical_options' => 'client_types',
  			),

  			array(
  				'id' => 'query_terms_includes_portfolio_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'portfolio_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('portfolio-types'),
   				'js_hierarchical_options' => 'portfolio_types',
  			),

				array(
  				'id' => 'query_terms_includes_category',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'category' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_get_categories('category'),
					'js_hierarchical_options' => 'blog_categories',
  			),

  			array(
  				'id' => 'query_terms_includes_offer_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'offer_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('offer-types'),
   				'js_hierarchical_options' => 'offer_types',
  			),

  			array(
  				'id' => 'query_terms_includes_testimonial_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'testimonial_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('testimonial-types'),
   				'js_hierarchical_options' => 'testimonial_types',
  			),

  			array(
  				'id' => 'query_terms_includes_product_cat',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'product_cat' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_hierarchical_taxonomy('product_cat'),
					'js_hierarchical_options' => 'product_cat',
					'opt_append' => 'current',
  			),

  			array(
  				'id' => 'query_terms_orderby',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'term_order' => __('Term order', 'mfn-opts'),
  					'term_id' => __('ID', 'mfn-opts'),
  					'name' => __('Name', 'mfn-opts'),
  					'count' => __('Count', 'mfn-opts'),
  				),
  				'std' => 'ID'
  			),

  			array(
  				'id' => 'query_terms_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'ASC'
  			),

  			array(
  				'id' => 'query_terms_hide_empty',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Hide empty', 'mfn-opts'),
  				'options' => array(
  					'' => __('False', 'mfn-opts'),
  					'1' => __('True', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_terms_number',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			/* END posts query builder */

  			array(
  				'class' => 'hidden-header-builder',
					'title' => __('Style', 'mfn-opts'),
				),

				array(
  				'class' => 'hidden-header-builder',
  				'id' => 'style',
  				'type' => 'checkbox_pseudo',
  				'title' => __('Style', 'mfn-opts'),
  				'desc' => __('<strong>Notice!</strong> Options grayed out and marked with OLD tag are deprecated and will be removed in the future. Please use <a href="https://support.muffingroup.com/documentation/muffin-live-builder/positioning/" target="_blank">Positioning</a> instead.', 'mfn-opts'),
  				'options' => mfna_section_style(),
  			),

				// shape dividers

				array(
					'class' => 'hidden-header-builder',
					'title' => __('Shape divider', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row hidden-header-builder mfn-sidebar-fields-tabs mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Top</a></li><li><a href="#hover" data-tab="hover">Bottom</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'id' => 'shape_divider_type_top',
					'class' => 'hidden-header-builder',
					'attr_id' => 'shape_divider_type_top',
					'type' => 'select',
					'title' => __('Type', 'mfn-opts'),
					'options' => Mfn_Builder_Helper::get_shape_divider('options'),
					'std' => 0,
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:--mfn-shape-divider',
					'class' => 'hidden-header-builder',
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:width',
					'class' => 'hidden-header-builder',
					'type' => 'sliderbar',
					'title' => __('Width %', 'mfn-opts'),
					'param' => array(
						'min' => '100',
						'max' => '300',
						'step' => '1',
						'unit' => '%',
					),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:height',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop hidden-header-builder',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:height_tablet',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet hidden-header-builder',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-top svg:height_mobile',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile hidden-header-builder',
				),

				array(
					'id' => 'shape_divider_flip_top',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Flip', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'id' => 'shape_divider_invert_top',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Invert', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'is', 'val' => Mfn_Builder_Helper::get_shape_divider('invert') ),
				),

				array(
					'id' => 'shape_divider_bring_front_top',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Bring to front', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_top', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'class' => 'hidden-header-builder',
					'id' => 'shape_divider_type_bottom',
					'attr_id' => 'shape_divider_type_bottom',
					'type' => 'select',
					'title' => __('Type', 'mfn-opts'),
					'options' => Mfn_Builder_Helper::get_shape_divider('options'),
					'std' => 0,
				),

				array(
					'class' => 'hidden-header-builder',
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:--mfn-shape-divider',
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
					'std' => '',
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'class' => 'hidden-header-builder',
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:width',
					'type' => 'sliderbar',
					'title' => __('Width %', 'mfn-opts'),
					'param' => array(
						'min' => '100',
						'max' => '300',
						'step' => '1',
						'unit' => '%',
					),
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:height',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop hidden-header-builder',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:height_tablet',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet hidden-header-builder',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mfn-shape-divider-bottom svg:height_mobile',
					'type' => 'sliderbar',
					'title' => __('Height px', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '500',
						'step' => '1',
						'unit' => 'px',
					),
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile hidden-header-builder',
				),

				array(
					'id' => 'shape_divider_flip_bottom',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Flip', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),

				array(
					'id' => 'shape_divider_invert_bottom',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Invert', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'is', 'val' => Mfn_Builder_Helper::get_shape_divider('invert') ),
				),

				array(
					'id' => 'shape_divider_bring_front_bottom',
					'type' => 'switch',
					'class' => 'hidden-header-builder',
					'title' => __('Bring to front', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
					'condition' => array( 'id' => 'shape_divider_type_bottom', 'opt' => 'isnt', 'val' => 0 ),
				),


				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

  			// decoration

  			array(
  				'class' => 'hidden-header-builder',
  				'title' => __('Background decoration', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'divider',
  				'type' => 'select',
  				'title' => __('Pattern', 'mfn-opts'),
  				'desc' => __('Please select background color in Advanced tab<br />Does <b>not</b> work with parallax and some section styles', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'circle up' => __('Circle up', 'mfn-opts'),
  					'square up' => __('Square up', 'mfn-opts'),
  					'triangle up' => __('Triangle up', 'mfn-opts'),
  					'triple-triangle up' => __('Triple triangle up', 'mfn-opts'),
  					'circle down' => __('Circle down', 'mfn-opts'),
  					'square down' => __('Square down', 'mfn-opts'),
  					'triangle down' => __('Triangle down', 'mfn-opts'),
  					'triple-triangle down' => __('Triple triangle down', 'mfn-opts'),
  				),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'decor_top',
  				'type' => 'upload',
  				'title' => __('Image top', 'mfn-opts'),
  				'desc' => __('for images from <b> Media library</b><br/>Recommended width: 1920px', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'decor_bottom',
  				'type' => 'upload',
  				'title' => __('Image bottom', 'mfn-opts'),
					'desc' => __('for images from <b> Media library</b><br/>Recommended width: 1920px', 'mfn-opts'),
  			),

  			// options

  			array(
  				'class' => 'hidden-header-builder',
  				'title' => __('Options', 'mfn-opts'),
  			),

				array(
					'class' => 'hidden-header-builder',
  				'id' => 'navigation',
  				'type' => 'select',
  				'title' => __('Navigation', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'arrows' => __('Arrows', 'mfn-opts'),
  				),
  			),

				// hidden attributes

  			array(
  				'id' => 'hide',
  				'type' => 'text',
  				'title' => __('Hide', 'mfn-opts'),
  				'row_class' => 'hidden',
  				'class' => 'mfn-hidden-form-row',
  			),

  			array(
  				'id' => 'collapse',
  				'type' => 'text',
  				'title' => __('Collapse', 'mfn-opts'),
  				'row_class' => 'hidden',
  				'class' => 'mfn-hidden-form-row',
  			),

				// deprecated

  			array(
  				'class' => 'mfn-deprecated',
  				'title' => __('Deprecated', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_color',
  				'type' => 'color',
  				'class' => 'mfn-deprecated',
  				'title' => __('Background color', 'mfn-opts'),
  				'alpha' => true,
  			),

  			array(
  				'id' => 'bg_image',
  				'class' => 'mfn-deprecated',
  				'type' => 'upload',
  				'title' => __('Background image', 'mfn-opts'),
  				'desc' => __('Recommended image size <b>1920px x 1080px</b>', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_position',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background position', 'mfn-opts'),
  				'desc' => __('iOS does <b>not</b> support background-position: fixed<br/>For parallax required background image size is at least 1920px x 1080px', 'mfn-opts'),
  				'options' => mfna_bg_position(),
  			),

  			array(
  				'id' => 'bg_size',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background size', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with position fixed or parallax', 'mfn-opts'),
  				'options' => mfna_bg_size(),
  			),

  			array(
  				'id' => 'padding_top',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding top', 'mfn-opts'),
  				'after' => 'px',
  			),

  			array(
  				'id' => 'padding_bottom',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding bottom', 'mfn-opts'),
  				'after' => 'px',
  			),

  			array(
  				'id' => 'padding_horizontal',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding left & right', 'mfn-opts'),
  				'desc' => __('Use <b>px</b> or <b>%</b>', 'mfn-opts'),
  			),

  			array(
  				'id' => 'visibility',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Default -', 'mfn-opts'),
  					'hide-desktop' => __('Hide on Desktop | 960px +', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet | 768px - 959px', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile | - 768px', 'mfn-opts'),			// - 768
  					'hide-desktop hide-tablet' => __('Hide on Desktop & Tablet', 'mfn-opts'),
  					'hide-desktop hide-mobile' => __('Hide on Desktop & Mobile', 'mfn-opts'),
  					'hide-tablet hide-mobile' => __('Hide on Tablet & Mobile', 'mfn-opts'),
  				),
  			),

  			array(
  				'id' => 'class',
  				'class' => 'mfn-deprecated',
  				'type' => 'pills',
  				'title' => __('Section classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'section_id',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Section ID', 'mfn-opts'),
  				'desc' => __('Use this option to create One Page sites<br />Example: Your <b>Section ID</b> is <b>offer</b> and you want to open this section, please use link: <b>your-url/#offer</b>', 'mfn-opts'),
					'param' => 'id',
  			),

				array(
					'type' => 'helper',
					'class' => 'mfn-deprecated',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/faq/what-deprecated-in-the-bebuilder-means/',
				),

  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-style">',
				),


				array(
					'class' => 'toggled_header',
					'title' => __('Container', 'mfn-opts'),
				),

				array(
  				'id' => 'query_display',
  				'attr_id' => 'query_display',
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Display', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'slider' => __('Slider', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_columns',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn_field_desktop narrow mfn-toggled',
  				'responsive' => 'desktop',
  				'type' => 'text',
  				're_render' => true,
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),

  			array(
  				'id' => 'query_slider_columns_tablet',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn_field_tablet narrow mfn-toggled',
  				'responsive' => 'tablet',
  				'type' => 'text',
  				're_render' => true,
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),

  			array(
  				'id' => 'query_slider_columns_mobile',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn_field_mobile narrow mfn-toggled',
  				'responsive' => 'mobile',
  				'type' => 'text',
  				're_render' => true,
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),

  			/*array(
  				'id' => 'query_slider_animation',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Animation', 'mfn-opts'),
  				'options' => array(
  					'' => __('Slide', 'mfn-opts'),
  					'fade' => __('Fade', 'mfn-opts'),
  				),
  				'std' => ''
  			),*/

  			array(
  				'id' => 'query_slider_infinity',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Infinite loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Off', 'mfn-opts'),
  					'1' => __('On', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_autoplay',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => '',
					'class' => 'mfn-toggled',
					'title' => __('Autoplay speed', 'mfn-opts'),
					'desc' => __('Leave empty to disallow autoplay', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '10000',
						'step' => '100',
						'unit' => '',
					)
  			),

  			array(
  				'id' => 'query_slider_arrows',
  				'attr_id' => 'query_slider_arrows',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Arrows', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_arrows_style',
  				'attr_id' => 'query_slider_arrows_style',
  				'condition' => array( 'id' => 'query_slider_arrows', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Arrows style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_dots',
  				'attr_id' => 'query_slider_dots',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Dots', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_dots_style',
  				'attr_id' => 'query_slider_dots_style',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Dots style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:transformtranslatex',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Translate(X)', 'mfn-opts'),
					'param' => array(
						'min' => '-100',
						'max' => '100',
						'step' => '1',
						'unit' => '%',
					)
				),

  			array(
  				'id' => 'query_slider_mousewheel',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Mousewheel', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_centered',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				're_render' => true,
  				'type' => 'switch',
  				'title' => __('Center mode', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					//'1' => __('Center', 'mfn-opts'),
  					'2' => __('Wrapper offset', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_display_style',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				// 're_render' => true,
  				'type' => 'switch',
  				'title' => __('Style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'masonry' => __('Masonry', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled query_item_default_width',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
					),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled query_item_default_width',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
					),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled query_item_default_width',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
					),
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Item', 'mfn-opts'),
				),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:padding_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:padding_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'padding',
  			),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:margin_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:margin_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-style',
					'attr_id' => 'border_style_ql',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-color',
					'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-width',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-width_tablet',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-width_mobile',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

  			array(
					'id' => 'background_switcher_ql',
					'attr_id' => 'background_switcher_ql',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher mfn-toggled disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:gradient',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-color',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-image',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'class' => 'mfn-toggled',
  				'title' => __('Image', 'mfn-opts'),
					'css_attr' => 'background-image',
  			),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-repeat',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-position',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),


				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-attachment',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-section-inner .mfn-queryloop-item-wrapper:background-size',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'class' => 'mfn-toggled',
					'type' => 'select',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Pagination', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),


				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:top_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:bottom_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:left_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:right_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),



				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:top_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:bottom_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:left_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .mcb-section-inner .swiper-pagination:right_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),



				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination:--mfn-swiper-pagination-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination:--mfn-swiper-pagination-spacing_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination:--mfn-swiper-pagination-spacing_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:border-radius',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Border radius', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination-bullet:opacity',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),

				array(
					'type' => 'html',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination .swiper-pagination-bullet:--swiper-pagination-bullet-inactive-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .swiper-pagination .swiper-pagination-bullet-active:--mfn-swiper-pagination-bullet-active-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Active color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Arrows', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Prev arrow custom style', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:top_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:bottom_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:left_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:right_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:top_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:bottom_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:left_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-prev.mfn-swiper-arrow:right_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Next arrow custom style', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:top_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:bottom_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:left_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:right_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:top_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:bottom_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:left_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .swiper-button-next.mfn-swiper-arrow:right_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mcb-section-inner .mfn-swiper-arrow:transformtranslatey',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Translate(Y)', 'mfn-opts'),
					'desc' => __('Moves navigation arrows along the Y-axis by the percent height', 'mfn-opts'),
					'default_unit' => '%',
					'after' => '%',
					'param' => array(
						'min' => '-100',
						'max' => '100',
						'step' => '1',
						'unit' => '%',
					)
				),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Custom arrows', 'mfn-opts'),
				),

				array(
					'id' => 'query_display_slider_arrow_prev',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Prev arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-left-open-big'
				),

				array(
					'id' => 'query_display_slider_arrow_next',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Next arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-right-open-big'
				),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Size', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow i:--mfn-swiper-arrow-size',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-width_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-height_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow i:--mfn-swiper-arrow-size_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-spacing_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-width_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-height_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow i:--mfn-swiper-arrow-size_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--mfn-swiper-arrow-spacing_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-style',
					'attr_id' => 'border_style_qlarr',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-width',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-width_tablet',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-width_mobile',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'class' => 'mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Color', 'mfn-opts'),
				),


				array(
					'type' => 'html',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow:border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow|hover:--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow|hover:background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.mfn-looped-items-slider-wrapper .mcb-section-inner .mfn-swiper-arrow|hover:border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),













  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-advanced">',
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Dimensions', 'mfn-opts'),
				),

				array(
					'id' => 'width_switcher',
					'attr_id' => 'sect_width_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'full' 		=> __('Full width', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.custom-width .section_wrapper:max-width',
					'condition' => array( 'id' => 'sect_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'text',
					'default_unit' => 'px',
					'class' => 'mfn-toggled narrow mfn-slider-input',
					'title' => __('Custom width', 'mfn-opts')
				),

				array(
					'id' => 'height_switcher',
					'attr_id' => 'sect_height_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'full-screen' => __('Full screen', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:height',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'sect_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled narrow mfn-slider-input',
					'title' => __('Custom height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:height_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'sect_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled narrow mfn-slider-input',
					'title' => __('Custom height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:height_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'sect_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled narrow mfn-slider-input',
					'title' => __('Custom height', 'mfn-opts')
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:padding_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:padding_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'padding',
  			),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:margin_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:margin_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'class' => 'toggled_header hide_if_ql',
					'title' => __('Positioning', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-content',
					'type' => 'radio_img',
					'alias' => 'section-flex-align-content',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'title' => __('Section content position', 'mfn-opts'),
					'options' => array(
						'' => 'Default',
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-content_tablet',
					'type' => 'radio_img',
					'alias' => 'section-flex-align-content',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Section content position', 'mfn-opts'),
					'options' => array(
						'' => 'Default',
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-content_mobile',
					'type' => 'radio_img',
					'alias' => 'section-flex-align-content',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Section content position', 'mfn-opts'),
					'options' => array(
						'' => 'Default',
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-items',
					'type' => 'radio_img',
					'alias' => 'section-flex-align',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop adv_align-items_section',
					'title' => __('Wraps vertical spacing', 'mfn-opts'),
					'options' => array(
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-items_tablet',
					'type' => 'radio_img',
					'alias' => 'section-flex-align',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet adv_align-items_section',
					'title' => __('Wraps vertical spacing', 'mfn-opts'),
					'options' => array(
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-items_mobile',
					'type' => 'radio_img',
					'alias' => 'section-flex-align',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile adv_align-items_section',
					'title' => __('Wraps vertical spacing', 'mfn-opts'),
					'options' => array(
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:justify-content',
					'type' => 'radio_img',
					'alias' => 'section-flex-justify',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:justify-content_tablet',
					'type' => 'radio_img',
					'alias' => 'section-flex-justify',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:justify-content_mobile',
					'type' => 'radio_img',
					'alias' => 'section-flex-justify',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'type' => 'helper',
					'class' => 'mfn-toggled',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/documentation/bebuilder/positioning/#section',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:z-index',
					'type' => 'text',
					'title' => __('Z-index', 'mfn-opts'),
					'param' => 'number',
					'class' => 'narrow mfn-toggled',
					'preview' => 'number',
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li class="visible-header-builder"><a href="#scroll" data-tab="scroll">Scroll</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
				),

				array(
					'id' => 'background_switcher',
					'attr_id' => 'background_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'video' => __('Video', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'video' 	=> '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:gradient',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-color',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:background-image',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

				array(
  				'id' => 'bg_video_mp4',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'video' ),
  				'class' => 'hidden-header-builder',
  				'type' => 'upload',
  				'title' => __('Video MP4', 'mfn-opts'),
  				'desc' => __('Image will be used as placeholder before video loads and on mobile devices', 'mfn-opts'),
  				'data' => 'video',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:background-image_tablet',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_image',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:background-image_mobile',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'dynamic_data' => 'featured_image',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-image',
  			),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement:background-repeat',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-repeat_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-repeat_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position',
					'attr_id' => 'bgposopt',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop bgposopt',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position_tablet',
					'attr_id' => 'bgposopt_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet bgposopt',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position_mobile',
					'attr_id' => 'bgposopt_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile bgposopt',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),











				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn-custom-bg-pos mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position_tablet_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt_tablet', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn-custom-bg-pos mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position_mobile_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt_mobile', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn-custom-bg-pos mfn_field_mobile',
				),






























				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-attachment',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-attachment_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-attachment_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size',
					'attr_id' => 'custombgsize',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop custombgsize',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size_tablet',
					'attr_id' => 'custombgsize_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet custombgsize',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size_mobile',
					'attr_id' => 'custombgsize_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile custombgsize',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),


				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn-custom-bg-size mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size_tablet_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize_tablet', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn-custom-bg-size mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size_mobile_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize_mobile', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn-custom-bg-size mfn_field_mobile',
				),



				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement|hover:gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement|hover:background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement|hover:background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

  			array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-scroll">',
				),

				array(
					'id' => 'style:.mfn-header-tmpl .mcb-section-mfnuidelement:transition',
					'type' => 'sliderbar',
					'style_prefix' => 'background ',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_scroll',
					'attr_id' => 'background_switcher_scroll',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement:gradient',
  				'condition' => array( 'id' => 'background_switcher_scroll', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement:background-color',
					'condition' => array( 'id' => 'background_switcher_scroll', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mfn-header-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement:background-image',
  				'condition' => array( 'id' => 'background_switcher_scroll', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

				array(
					'type' => 'html',
					'html' => '</div></div>', // end: mfn-sidebar-fields-tabs
				),

				// Background Overlay

				array(
  				'class' => 'toggled_header',
					'title' => __('Background overlay', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),

				array(
					'id' => 'background_overlay_switcher',
					'attr_id' => 'background_overlay_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:gradient',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-color',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-image',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-image_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_image',
					'type' => 'upload',
					'title' => __('Image', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-image',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-image_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'upload',
					'title' => __('Image', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-image',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-repeat',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-repeat_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-repeat_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-position',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-position_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-position_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-attachment',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-attachment_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-attachment_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-size',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-size_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:background-size_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:filter',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'css_filters',
					//'label_after' => '<a class="reset-css-filters" name="reset-css-filters" href="#">RES</a><a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
					'label_after' => '<a name="reset-css-filters" href="#" class="mfn-option-btn mfn-option-blank btn-medium reset-css-filters" data-tooltip="Reset"><span class="mfn-icon mfn-icon-reset"></span></a><a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
					'class' => 'mfn-toggled toggle_fields',
					'title' => __('CSS Filters', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .mcb-background-overlay:transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					//'std' => '1',
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
						'default' => __('Default', 'mfn-opts'),
						'gradient' 	=> __('Gradient', 'mfn-opts'),
					),
					'visual_options' => array(
						'default' => '',
						'gradient' 	=> '',
					),
					'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:gradient',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
					'type' => 'gradient',
					'title' => __('Gradient', 'mfn-opts'),
					'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement|hover .mcb-background-overlay:background-image',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_color',
					'type' => 'upload',
					'title' => __('Image', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
				),

				array(
					'type' => 'html',
					'html' => '</div></div>', // end: mfn-sidebar-fields-tabs
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Border', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:border-style',
					'attr_id' => 'border_style_sect',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:border-color',
					'condition' => array( 'id' => 'border_style_sect', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-width',
  				'condition' => array( 'id' => 'border_style_sect', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-width_tablet',
  				'condition' => array( 'id' => 'border_style_sect', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-width_mobile',
  				'condition' => array( 'id' => 'border_style_sect', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'box-shadow'
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:box-shadow_tablet',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:box-shadow_mobile',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'box-shadow',
  			),


  			array(
					'class' => 'toggled_header',
					'title' => __('Responsive', 'mfn-opts'),
				),

				array(
  				'id' => 'visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'active_tooltip' => array(
  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'options' => array(
  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'visual_options' => array(
  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'reverse_order',
  				'class' => 'mfn-toggled hide_if_ql',
  				'type' => 'switch',
  				'iconinfo' => 'https://support.muffingroup.com/how-to/how-to-reverse-the-order-of-elements-on-mobile/',
  				'title' => __('Order on mobile', 'mfn-opts'),
					'options' => [
						0 => __('Default', 'mfn-opts'),
						1 => __('Reverse rows', 'mfn-opts'),
						2 => __('Reverse columns', 'mfn-opts'),
					],
					'std' => 0,
  			),

				array(
					'class' => 'toggled_header',
					'title' => __('Custom', 'mfn-opts'),
				),

				array(
  				'id' => 'classes',
  				'oldid' => 'class',
  				'class' => 'mfn-toggled',
  				'type' => 'pills',
  				'title' => __('Classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_id',
  				'oldid' => 'section_id',
  				'class' => 'mfn-toggled',
  				'type' => 'text',
  				'title' => __('ID', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_css',
  				'oldid' => 'style',
  				'class' => 'mfn-toggled',
  				'type' => 'textarea',
  				'title' => __('Additional CSS', 'mfn-opts'),
  			),

			  array(
				'id' => 'global_sections',
				'class' => 'toggled_header global_sections',
				'title' => __('Global Section', 'mfn-opts'),
			),

			array(
				'id' => 'global_sections_select',
				'attr_id' => 'global_sections_select',
				'class' => 'mfn-toggled global_sections',
				'type' => 'select',
				'title' => __('Select template', 'mfn-opts'),
				'std' => '',
				'js_options' => 'global_sections',
				'options' => mfna_templates('section'),
			),

  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				)

  		);

  	}

    /**
     * SET wrap fields
   	 */

    private function set_wrap()
  	{
  		$this->wrap = array(

  			/**
  			 * HEADER additional fields
  			* */

  			array(
					'type' => 'html',
					'html' => $this->tabs,
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
				),

				// options

				array(
					'class' => 'hidden-header-builder',
					'title' => __('Options', 'mfn-opts'),
				),

  			array(
  				'id' => 'sticky',
  				'attr_id' => 'wrap_sticky_desktop',
  				'class' => 'hidden-header-builder mfn_field_desktop',
  				'type' => 'switch',
  				'responsive' => 'desktop',
  				'title' => __('Sticky', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with Move up and Parallax', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			array(
  				'id' => 'tablet_sticky',
  				'attr_id' => 'wrap_sticky_tablet',
  				'class' => 'hidden-header-builder mfn_field_tablet',
  				'type' => 'switch',
  				'responsive' => 'tablet',
  				'title' => __('Sticky', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with Move up and Parallax', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			array(
  				'id' => 'mobile_sticky',
  				'attr_id' => 'wrap_sticky_mobile',
  				'class' => 'hidden-header-builder mfn_field_mobile',
  				'type' => 'switch',
  				'responsive' => 'mobile',
  				'title' => __('Sticky', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with Move up and Parallax', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			array(
					'id' => 'info',
					'class' => 'visible-header-builder',
					'type' => 'info',
					'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
				),












  			array(
  				'id' => 'type',
  				're_render' => true,
  				'attr_id' => 'wrap_type',
  				'class' => 'hidden-header-builder mfn-loop-switcher',
  				'type' => 'switch',
  				'title' => __('Type', 'mfn-opts'),
  				'desc' => __('Query loop displays wrap&apos;s content in designed loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'query' => __('Query loop', 'mfn-opts'),
  				),
  				'std' => ''
  			),


  			/* query type */

  			array(
  				'id' => 'query_type',
  				're_render' => true,
  				'attr_id' => 'query_type',
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'wrap_type', 'opt' => 'is', 'val' => 'query' ),
  				'type' => 'select',
  				'title' => __('Query type', 'mfn-opts'),
  				'options' => array(
  					'' => __('Select', 'mfn-opts'),
  					'posts' => __('Posts', 'mfn-opts'),
  					'terms' => __('Terms', 'mfn-opts')
  				),
  				'std' => ''
  			),

  			/* posts query builder */

  			array(
  				'id' => 'query_post_type',
  				're_render' => true,
  				'attr_id' => 'query_post_type',
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Post type', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'post' => __('Post', 'mfn-opts'),
  					'page' => __('Page', 'mfn-opts'),
  					'portfolio' => __('Portfolio', 'mfn-opts'),
  					'offer' => __('Offer', 'mfn-opts'),
  					'slide' => __('Slides', 'mfn-opts'),
  					'product' => __('Product', 'mfn-opts'),
  					'testimonial' => __('Testimonial', 'mfn-opts'),
  				),
  				'std' => 'post'
  			),

  			array(
					'id' => 'query_post_type_product',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'product' ),
					're_render' => true,
					'class' => 'mfn-reset-if-term',
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_hierarchical_taxonomy('product_cat'),
					'js_hierarchical_options' => 'product_cat',
					'opt_append' => 'current',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_testimonial',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'testimonial' ),
					're_render' => true,
					'class' => 'mfn-reset-if-term',
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'options' => mfn_get_categories('testimonial-types'),
   				'js_hierarchical_options' => 'testimonial_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_post',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'post' ),
					're_render' => true,
					'class' => 'mfn-reset-if-term',
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('category'),
					'js_hierarchical_options' => 'blog_categories',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_portfolio',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'portfolio' ),
					're_render' => true,
					'class' => 'mfn-reset-if-term',
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('portfolio-types'),
					'js_hierarchical_options' => 'portfolio_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_client',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'client' ),
					're_render' => true,
					'class' => 'mfn-reset-if-term',
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('client-types'),
					'js_hierarchical_options' => 'client_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_offer',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'offer' ),
					're_render' => true,
					'class' => 'mfn-reset-if-term',
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('offer-types'),
					'js_hierarchical_options' => 'offer_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_slide',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'slide' ),
					're_render' => true,
					'class' => 'mfn-reset-if-term',
					'type' => 'select',
					'title' => __('Category', 'mfn-opts'),
					'hierarchical_options' => mfn_get_categories('slide-types'),
					'js_hierarchical_options' => 'slide_types',
					'preview' => 'category',
				),

				array(
					'id' => 'query_post_type_product_order',
					'condition' => array( 'id' => 'query_post_type', 'opt' => 'is', 'val' => 'product' ),
					're_render' => true,
					'type' => 'select',
					'desc' => __('This option turns off standard order settings', 'mfn-opts'),
					'title' => __('Display', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'on_sale' => __('On sale', 'mfn-opts'),
						'best_selling' => __('Best selling', 'mfn-opts'),
						'top_rated' => __('Top rated', 'mfn-opts'),
					),
					'std' => '',
				),

  			array(
  				'id' => 'query_post_orderby',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'ID' => __('ID', 'mfn-opts'),
  					'date' => __('Date', 'mfn-opts'),
  					'modified' => __('Modified', 'mfn-opts'),
  					'title' => __('Title', 'mfn-opts'),
  					'rand' => __('Rand', 'mfn-opts'),
  				),
  				'std' => 'date'
  			),

  			array(
  				'id' => 'query_post_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'ASC'
  			),

  			array(
  				'id' => 'query_post_per_page',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			array(
  				'id' => 'query_post_offset',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'posts' ),
  				'type' => 'text',
  				'title' => __('Offset', 'mfn-opts'),
  				'desc' => __('This option omits provided quantity of posts (from the beginning)', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),

  			/* terms query builder */

  			array(
  				'id' => 'query_terms_taxonomy',
  				'attr_id' => 'query_terms_taxonomy',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Taxonomy', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Select -', 'mfn-opts'),
  					'category' => __('Post category', 'mfn-opts'),
  					'post_tag' => __('Post tag', 'mfn-opts'),
  					'portfolio_types' => __('Portfolio category', 'mfn-opts'),
  					'offer_types' => __('Offer category', 'mfn-opts'),
  					'product_cat' => __('Product category', 'mfn-opts'),
  					'testimonial_types' => __('Testimonial category', 'mfn-opts'),
  				),
  				'std' => 'category'
  			),

  			array(
  				'id' => 'query_terms_excludes_post_tag',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'post_tag' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('post_tag'),
   				'js_hierarchical_options' => 'blog_tags',
  			),

  			array(
  				'id' => 'query_terms_excludes_client_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'client_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('client-types'),
   				'js_hierarchical_options' => 'client_types',
  			),

  			array(
  				'id' => 'query_terms_excludes_portfolio_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'portfolio_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('portfolio-types'),
   				'js_hierarchical_options' => 'portfolio_types',
  			),

				array(
  				'id' => 'query_terms_excludes_category',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'category' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_get_categories('category'),
					'js_hierarchical_options' => 'blog_categories',
  			),

  			array(
  				'id' => 'query_terms_excludes_offer_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'offer_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('offer-types'),
   				'js_hierarchical_options' => 'offer_types',
  			),

  			array(
  				'id' => 'query_terms_excludes_testimonial_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'testimonial_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('testimonial-types'),
   				'js_hierarchical_options' => 'testimonial_types',
  			),

  			array(
  				'id' => 'query_terms_excludes_product_cat',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'product_cat' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Excludes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_hierarchical_taxonomy('product_cat'),
					'js_hierarchical_options' => 'product_cat',
  			),

  			array(
  				'id' => 'query_terms_includes_post_tag',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'post_tag' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('post_tag'),
   				'js_hierarchical_options' => 'blog_tags',
  			),

  			array(
  				'id' => 'query_terms_includes_client_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'client_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('client-types'),
   				'js_hierarchical_options' => 'client_types',
  			),

  			array(
  				'id' => 'query_terms_includes_portfolio_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'portfolio_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('portfolio-types'),
   				'js_hierarchical_options' => 'portfolio_types',
  			),

				array(
  				'id' => 'query_terms_includes_category',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'category' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_get_categories('category'),
					'js_hierarchical_options' => 'blog_categories',
  			),

  			array(
  				'id' => 'query_terms_includes_offer_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'offer_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('offer-types'),
   				'js_hierarchical_options' => 'offer_types',
  			),

  			array(
  				'id' => 'query_terms_includes_testimonial_types',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'testimonial_types' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'options' => mfn_get_categories('testimonial-types'),
   				'js_hierarchical_options' => 'testimonial_types',
  			),

  			array(
  				'id' => 'query_terms_includes_product_cat',
  				'condition' => array( 'id' => 'query_terms_taxonomy', 'opt' => 'is', 'val' => 'product_cat' ),
  				're_render' => true,
  				'type' => 'multiselect',
  				'title' => __('Includes', 'mfn-opts'),
  				'desc' => __('IDs of taxonomies to exclude', 'mfn-opts'),
  				'hierarchical_options' => mfn_hierarchical_taxonomy('product_cat'),
					'js_hierarchical_options' => 'product_cat',
					'opt_append' => 'current',
  			),

  			array(
  				'id' => 'query_terms_orderby',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order by', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'term_order' => __('Term order', 'mfn-opts'),
  					'term_id' => __('ID', 'mfn-opts'),
  					'name' => __('Name', 'mfn-opts'),
  					'count' => __('Count', 'mfn-opts'),
  				),
  				'std' => 'ID'
  			),

  			array(
  				'id' => 'query_terms_order',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Order', 'mfn-opts'),
  				'options' => array(
  					'ASC' => __('Ascending', 'mfn-opts'),
  					'DESC' => __('Descending', 'mfn-opts'),
  				),
  				'std' => 'ASC'
  			),

  			array(
  				'id' => 'query_terms_hide_empty',
  				'class' => 'hidden-header-builder',
  				're_render' => true,
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'select',
  				'title' => __('Hide empty', 'mfn-opts'),
  				'options' => array(
  					'' => __('False', 'mfn-opts'),
  					'1' => __('True', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_terms_number',
  				're_render' => true,
  				'class' => 'hidden-header-builder',
  				'condition' => array( 'id' => 'query_type', 'opt' => 'is', 'val' => 'terms' ),
  				'type' => 'text',
  				'title' => __('Limit', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '0',
  			),





				// deprecated

				array(
					'class' => 'hidden-header-builder mfn-deprecated',
					'title' => __('Deprecated', 'mfn-opts'),
				),

				array(
  				'id' => 'bg_color',
  				'class' => 'mfn-deprecated',
  				'type' => 'color',
  				'title' => __('Background color', 'mfn-opts'),
  				'alpha' => true,
  			),

  			array(
  				'id' => 'bg_image',
  				'class' => 'mfn-deprecated',
  				'type' => 'upload',
  				'title' => __('Background image', 'mfn-opts'),
  				'desc' => __('Recommended image width <b>320px - 1920px</b> depending on size of the wrap', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_position',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background position', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-position: fixed<br/>For parallax required background image size is at least 1920px x 1080px', 'mfn-opts'),
  				'options' => mfna_bg_position(),
  			),

  			array(
  				'id' => 'bg_size',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background size', 'mfn-opts'),
					'desc' => __('Does <b>not</b> work with position fixed or parallax', 'mfn-opts'),
  				'options' => mfna_bg_size(),
  			),

  			array(
  				'id' => 'move_up',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Move up', 'mfn-opts'),
  				'desc' => __('Move this wrap to overflow on previous section. Does <b>not</b> work with parallax', 'mfn-opts'),
  				'after' => 'px',
  			),

  			array(
  				'id' => 'padding',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding', 'mfn-opts'),
  				'desc' => __('Use value with <b>px</b> or <b>%</b><br />Example: 20px or 20px 10px 20px 10px or 20px 1%', 'mfn-opts'),
  			),

  			array(
  				'id' => 'column_margin',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Elements margin bottom', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Default -', 'mfn-opts'),
  					'0px' => '0px',
  					'10px' => '10px',
  					'20px' => '20px',
  					'30px' => '30px',
  					'40px' => '40px',
  					'50px' => '50px',
  				),
  			),

				array(
  				'id' => 'vertical_align',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Elements vertical align', 'mfn-opts'),
  				'desc' => __('for Section style: <b>Equal height of wraps</b>', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'top' => __('Top', 'mfn-opts'),
  					'middle' => __('Middle', 'mfn-opts'),
  					'bottom' => __('Bottom', 'mfn-opts'),
  				),
  			),

				array(
					'id' => 'class',
					'type' => 'pills',
					'title' => __('Wrap classes', 'mfn-opts'),
					'class' => 'mfn-deprecated',
				),

				array(
					'id' => 'style',
					'type' => 'textarea',
					'title' => __('Wrap inline CSS', 'mfn-opts'),
					'desc' => __('Example: <b>border: 1px solid #999;</b>', 'mfn-opts'),
					'class' => 'mfn-deprecated',
				),

				array(
					'type' => 'helper',
					'class' => 'mfn-deprecated',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/faq/what-deprecated-in-the-bebuilder-means/',
				),

				array(
					'type' => 'html',
					'html' => '</div>',
				),















				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-style">',
				),


				array(
					'class' => 'toggled_header',
					'title' => __('Container', 'mfn-opts'),
				),

				array(
  				'id' => 'query_display',
  				'attr_id' => 'query_display',
  				're_render' => true,
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Display', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'slider' => __('Slider', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_columns',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn_field_desktop narrow mfn-toggled',
  				'responsive' => 'desktop',
  				're_render' => true,
  				'type' => 'text',
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),

  			array(
  				'id' => 'query_slider_columns_tablet',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn_field_tablet narrow mfn-toggled',
  				'responsive' => 'tablet',
  				'type' => 'text',
  				're_render' => true,
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),

  			array(
  				'id' => 'query_slider_columns_mobile',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn_field_mobile narrow mfn-toggled',
  				'responsive' => 'mobile',
  				'type' => 'text',
  				're_render' => true,
  				'title' => __('Columns', 'mfn-opts'),
  				'param' => 'number',
					'preview' => 'number',
					'std' => '1',
  			),

  			/*array(
  				'id' => 'query_slider_animation',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Animation', 'mfn-opts'),
  				'options' => array(
  					'' => __('Slide', 'mfn-opts'),
  					'fade' => __('Fade', 'mfn-opts'),
  				),
  				'std' => ''
  			),*/

  			array(
  				'id' => 'query_slider_infinity',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Infinite loop', 'mfn-opts'),
  				'options' => array(
  					'' => __('Off', 'mfn-opts'),
  					'1' => __('On', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_autoplay',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => '',
					'class' => 'mfn-toggled',
					'title' => __('Autoplay speed', 'mfn-opts'),
					'desc' => __('Leave empty to disallow autoplay', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '10000',
						'step' => '100',
						'unit' => '',
					)
  			),

  			array(
  				'id' => 'query_slider_arrows',
  				'attr_id' => 'query_slider_arrows',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Arrows', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_arrows_style',
  				'attr_id' => 'query_slider_arrows_style',
  				'condition' => array( 'id' => 'query_slider_arrows', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Arrows style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_dots',
  				'attr_id' => 'query_slider_dots',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Dots', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Hide', 'mfn-opts'),
  					'1' => __('Show', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'query_slider_dots_style',
  				'attr_id' => 'query_slider_dots_style',
  				'condition' => array( 'id' => 'query_slider_dots', 'opt' => 'is', 'val' => '1' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Dots style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Standard', 'mfn-opts'),
  					'overlay' => __('Overlay', 'mfn-opts'),
  					'custom' => __('Custom', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_slider_mousewheel',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Mousewheel', 'mfn-opts'),
  				'options' => array(
  					'' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'query_display_style',
  				'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'title' => __('Style', 'mfn-opts'),
  				'options' => array(
  					'' => __('Default', 'mfn-opts'),
  					'masonry' => __('Masonry', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled query_item_default_width',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
					),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled query_item_default_width',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
					),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper.mfn-ql-item-default:width_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'isnt', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'default_unit' => 'px',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled query_item_default_width',
					'title' => __('Item width', 'mfn-opts'),
					'units' => array(
						'px' 	=> array('min' => 0, 'max' => 1920, 'step' => 1),
						'%' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
						'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 0.1),
					),
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Item', 'mfn-opts'),
				),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:padding_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:padding_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'padding',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:margin_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:margin_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'margin',
  			),









  			array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-style',
					'attr_id' => 'border_style_ql',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-color',
					'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-width',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-width_tablet',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-width_mobile',
  				'condition' => array( 'id' => 'border_style_ql', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

  			array(
					'id' => 'background_switcher_ql',
					'attr_id' => 'background_switcher_ql',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher mfn-toggled disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:gradient',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-color',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-image',
  				'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'class' => 'mfn-toggled',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
					'css_attr' => 'background-image',
  			),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-repeat',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-position',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),


				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-attachment',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'class' => 'mfn-toggled',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mfn-queryloop-item-wrapper:background-size',
					'condition' => array( 'id' => 'background_switcher_ql', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'class' => 'mfn-toggled',
					'type' => 'select',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),


				array(
					'class' => 'toggled_header',
					'title' => __('Pagination', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled dots-custom-style mfn_field_desktop',
				),




				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:top_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:bottom_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:left_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:right_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled dots-custom-style mfn_field_tablet',
				),


				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:top_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:bottom_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:left_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-dots-custom .swiper-pagination:right_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_dots_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled dots-custom-style mfn_field_mobile',
				),



				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination:--mfn-swiper-pagination-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination:--mfn-swiper-pagination-spacing_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination:--mfn-swiper-pagination-spacing_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Offset', 'mfn-opts'),
					'desc' => __('Works with Standard and Overlay pagination mode', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination .swiper-pagination-bullet:--swiper-pagination-bullet-inactive-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination .swiper-pagination-bullet-active:--mfn-swiper-pagination-bullet-active-color',
					'type' => 'color',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'class' => 'mfn-toggled',
					'title' => __('Active color', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-width_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:--mfn-swiper-pagination-bullet-height_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:border-radius',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Border radius', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '100',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .swiper-pagination-bullet:opacity',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),








				array(
					'class' => 'toggled_header',
					'title' => __('Arrows', 'mfn-opts'),
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
				),

				array(
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Prev arrow custom style', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),


				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:top_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:bottom_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:left_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:right_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),



				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:top_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:bottom_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:left_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-prev.mfn-swiper-arrow:right_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),



				array(
  				'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Next arrow custom style', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_desktop',
				),



				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:top_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:bottom_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:left_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:right_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_tablet',
				),



				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:top_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Top', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:bottom_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Bottom', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:left_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Left', 'mfn-opts'),
						'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .swiper-button-next.mfn-swiper-arrow:right_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Right', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled arrows-custom-style mfn_field_mobile',
				),



				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper.mfn-arrows-custom .mfn-swiper-arrow:transformtranslatey',
					'condition' => array( 'id' => 'query_slider_arrows_style', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Translate(Y)', 'mfn-opts'),
					'desc' => __('Moves navigation arrows along the Y-axis by the percent height', 'mfn-opts'),
					'after' => '%',
					'param' => array(
						'min' => '-100',
						'max' => '100',
						'step' => '1',
						'unit' => '%',
					)
				),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Custom arrows', 'mfn-opts'),
				),

				array(
					'id' => 'query_display_slider_arrow_prev',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Prev arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-left-open-big'
				),

				array(
					'id' => 'query_display_slider_arrow_next',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'icon',
					'class' => 'mfn-toggled',
					'title' => __('Next arrow', 'mfn-opts'),
					'preview' => 'icon',
					'std' => 'icon-right-open-big'
				),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Size', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-width',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'after' => 'px',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Width', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-height',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'after' => 'px',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Height', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow i:--mfn-swiper-arrow-size',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-spacing',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn_field_desktop',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),




				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-width_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-height_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow i:--mfn-swiper-arrow-size_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-spacing_tablet',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn_field_tablet',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),




				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-width_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Width', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-height_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Height', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow i:--mfn-swiper-arrow-size_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Size', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '0',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--mfn-swiper-arrow-spacing_mobile',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'type' => 'sliderbar',
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn_field_mobile',
					'title' => __('Offset', 'mfn-opts'),
					'after' => 'px',
					'param' => array(
						'min' => '-300',
						'max' => '300',
						'step' => '1',
						'unit' => 'px',
					)
				),





				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'title' => __('Border', 'mfn-opts'),
				),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-style',
					'attr_id' => 'border_style_qlarr',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-width',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-width_tablet',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-width_mobile',
  				'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'class' => 'mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

				array(
					'class' => 'mfn-builder-subheader mfn-toggled',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'title' => __('Color', 'mfn-opts'),
				),


				array(
					'type' => 'html',
					'condition' => array( 'id' => 'query_display', 'opt' => 'is', 'val' => 'slider' ),
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow:border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow|hover:--swiper-navigation-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow|hover:background-color',
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement.mfn-looped-items-slider-wrapper .mfn-swiper-arrow|hover:border-color',
					'condition' => array( 'id' => 'border_style_qlarr', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),













  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				),























				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-advanced">',
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Dimensions', 'mfn-opts'),
				),

				array(
					'id' => 'width_switcher',
					'attr_id' => 'wrap_width_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'desktop',
					'default_unit' => 'px',
					'class' => 'mfn_field_desktop mfn-toggled advanced_flex mfn-slider-input',
					'title' => __('Width', 'mfn-opts'),
					'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex_tablet',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'tablet',
					'default_unit' => 'px',
					'class' => 'mfn_field_tablet mfn-toggled advanced_flex mfn-slider-input',
					'title' => __('Width', 'mfn-opts'),
					'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex_mobile',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'mobile',
					'default_unit' => 'px',
					'class' => 'mfn_field_mobile mfn-toggled advanced_flex mfn-slider-input',
					'title' => __('Width', 'mfn-opts'),
					'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
				),

				array(
					'id' => 'height_switcher',
					'attr_id' => 'wrap_height_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:height',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled adv_height_wrap mfn-slider-input',
					'title' => __('Height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:height_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled adv_height_wrap mfn-slider-input',
					'title' => __('Height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:height_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled adv_height_wrap mfn-slider-input',
					'title' => __('Height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex-grow',
					'type' => 'select',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'default' ),
					'class' => 'mfn-toggled visible-header-builder mfn_field_desktop',
					'responsive' => 'desktop',
					'title' => __('Fit container', 'mfn-opts'),
					'options' => array(
						'unset' => __('Default', 'mfn-opts'),
  					'1' => __('Fit', 'mfn-opts'),
  				),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex-grow_tablet',
					'type' => 'select',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'default' ),
					'class' => 'mfn-toggled visible-header-builder mfn_field_tablet',
					'responsive' => 'tablet',
					'title' => __('Fit container', 'mfn-opts'),
					'options' => array(
						'unset' => __('Default', 'mfn-opts'),
  					'1' => __('Fit', 'mfn-opts'),
  				),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex-grow_mobile',
					'type' => 'select',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'default' ),
					'class' => 'mfn-toggled visible-header-builder mfn_field_mobile',
					'responsive' => 'mobile',
					'title' => __('Fit container', 'mfn-opts'),
					'options' => array(
						'unset' => __('Default', 'mfn-opts'),
  					'1' => __('Fit', 'mfn-opts'),
  				),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:flex-wrap',
					'type' => 'select',
					'class' => 'mfn-toggled visible-header-builder mfn_field_desktop',
					'responsive' => 'desktop',
					'title' => __('Wrap elements', 'mfn-opts'),
					'options' => array(
						'nowrap' => __('Nowrap', 'mfn-opts'),
  					'wrap' => __('Wrap', 'mfn-opts'),
  				),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:flex-wrap_tablet',
					'type' => 'select',
					'class' => 'mfn-toggled visible-header-builder mfn_field_tablet',
					'responsive' => 'tablet',
					'title' => __('Wrap elements', 'mfn-opts'),
					'options' => array(
						'nowrap' 	=> __('Nowrap', 'mfn-opts'),
  					'wrap' => __('Wrap', 'mfn-opts'),
  				),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:flex-wrap_mobile',
					'type' => 'select',
					'class' => 'mfn-toggled visible-header-builder mfn_field_mobile',
					'responsive' => 'mobile',
					'title' => __('Wrap elements', 'mfn-opts'),
					'options' => array(
						'nowrap' 	=> __('Nowrap', 'mfn-opts'),
  					'wrap' => __('Wrap', 'mfn-opts'),
  				),
				),

  			array(
  				'class' => 'toggled_header',
						'title' => __('Spacing', 'mfn-opts'),
					),

					array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:padding_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:padding_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'padding',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:margin',
  				'oldid' => 'move_up',
  				'version' => 'separated-fields',
  				'type' => 'dimensions',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled advanced_margin',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:margin_tablet',
  				'oldid' => 'move_up',
  				'version' => 'separated-fields',
  				'type' => 'dimensions',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled advanced_margin',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:margin_mobile',
  				'oldid' => 'move_up',
  				'version' => 'separated-fields',
  				'type' => 'dimensions',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled advanced_margin',
					'css_attr' => 'margin',
  			),

  			array(
  				'class' => 'toggled_header hide_if_ql',
					'title' => __('Positioning', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:align-self',
					'condition' => array( 'id' => 'wrap_sticky_desktop', 'opt' => 'is', 'val' => '0' ),
					'type' => 'radio_img',
					'alias' => 'flex-align-self',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop adv_alignself_wrap',
					'title' => __('Wrap position', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:align-self_tablet',
					'condition' => array( 'id' => 'wrap_sticky_tablet', 'opt' => 'is', 'val' => '0' ),
					'type' => 'radio_img',
					'alias' => 'flex-align-self',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Wrap position', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:align-self_mobile',
					'condition' => array( 'id' => 'wrap_sticky_mobile', 'opt' => 'is', 'val' => '0' ),
					'type' => 'radio_img',
					'alias' => 'flex-align-self',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Wrap position', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-content',
					'oldid' => 'vertical_align',
					'type' => 'radio_img',
					'alias' => 'flex-align-content',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'title' => __('Wrap content position', 'mfn-opts'),
					'desc' => __('Works with <b>Stretch</b> only', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
						'space-between' => 'Space between',
						'space-around' => 'Space around',
						'space-evenly' => 'Space evenly'
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-content_tablet',
					'oldid' => 'vertical_align',
					'type' => 'radio_img',
					'alias' => 'flex-align-content',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Wrap content position', 'mfn-opts'),
					'desc' => __('Works with <b>Stretch</b> only', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
						'space-between' => 'Space between',
						'space-around' => 'Space around',
						'space-evenly' => 'Space evenly'
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-content_mobile',
					'oldid' => 'vertical_align',
					'type' => 'radio_img',
					'alias' => 'flex-align-content',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Wrap content position', 'mfn-opts'),
					'desc' => __('Works with <b>Stretch</b> only', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
						'space-between' => 'Space between',
						'space-around' => 'Space around',
						'space-evenly' => 'Space evenly'
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-items',
					'type' => 'radio_img',
					'alias' => 'flex-align-items',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'responsive' => 'desktop',
					'title' => __('Elements vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch columns',
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-items_tablet',
					'type' => 'radio_img',
					'alias' => 'flex-align-items',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'responsive' => 'tablet',
					'title' => __('Elements vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch columns',
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-items_mobile',
					'type' => 'radio_img',
					'alias' => 'flex-align-items',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'responsive' => 'mobile',
					'title' => __('Elements vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch columns',
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:justify-content',
					'type' => 'radio_img',
					'alias' => 'flex-justify',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'responsive' => 'desktop',
					'title' => __('Elements horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:justify-content_tablet',
					'type' => 'radio_img',
					'alias' => 'flex-justify',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'responsive' => 'tablet',
					'title' => __('Elements horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:justify-content_mobile',
					'type' => 'radio_img',
					'alias' => 'flex-justify',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'responsive' => 'mobile',
					'title' => __('Elements horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'type' => 'helper',
					'class' => 'mfn-toggled',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/documentation/bebuilder/positioning/#wrap',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:z-index',
					'type' => 'text',
					'title' => __('Z-index', 'mfn-opts'),
					'param' => 'number',
					'class' => 'narrow mfn-toggled',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:order',
					'type' => 'text',
					'title' => __('Order', 'mfn-opts'),
					'param' => 'number',
						'class' => 'mfn_field_desktop narrow mfn-toggled',
						'responsive' => 'desktop',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:order_tablet',
					'type' => 'text',
					'title' => __('Order', 'mfn-opts'),
					'param' => 'number',
						'class' => 'mfn_field_tablet narrow mfn-toggled',
						'responsive' => 'tablet',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:order_mobile',
					'type' => 'text',
					'title' => __('Order', 'mfn-opts'),
					'param' => 'number',
						'class' => 'mfn_field_mobile narrow mfn-toggled',
						'responsive' => 'mobile',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:position',
					'attr_id' => 'wrap_position',
					'type' => 'select',
					'class' => 'mfn-toggled custom-element-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'relative' => __('Offset', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:top',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Top', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:bottom',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Bottom', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:left',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Left', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:right',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'isnt', 'val' => '' ),
					'title' => __('Right', 'mfn-opts'),
					'class' => 'mfn-toggled custom-abs-offset-values',
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
				),

				array(
					'id' => 'background_switcher',
					'attr_id' => 'background_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-color',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:gradient',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-image',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-image_tablet',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_image',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-image_mobile',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'dynamic_data' => 'featured_image',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-image',
  			),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-repeat',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-repeat_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-repeat_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position',
					'attr_id' => 'bgposopt',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'bgposopt mfn_field_desktop',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position_tablet',
					'attr_id' => 'bgposopt_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'bgposopt mfn_field_tablet',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position_mobile',
					'attr_id' => 'bgposopt_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'bgposopt mfn_field_mobile',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
				),






















				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn-custom-bg-pos mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position_tablet_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt_tablet', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn-custom-bg-pos mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position_mobile_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'bgposopt_mobile', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background position', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn-custom-bg-pos mfn_field_mobile',
				),




























				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-attachment',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-attachment_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-attachment_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size',
					'attr_id' => 'custombgsize',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop custombgsize',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size_tablet',
					'attr_id' => 'custombgsize_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet custombgsize',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size_mobile',
					'attr_id' => 'custombgsize_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile custombgsize',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'auto' => __('Auto', 'mfn-opts'),
						'contain' => __('Contain', 'mfn-opts'),
						'cover' => __('Cover', 'mfn-opts'),
						'cover-ultrawide' => __('Cover, on ultrawide screens only > 1920px', 'mfn-opts'),
						'custom' => __('Custom', 'mfn-opts'),
					],
					//'options' => mfna_bg_size()
				),



				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn-toggled mfn-custom-bg-size mfn_field_desktop',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size_tablet_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize_tablet', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn-toggled mfn-custom-bg-size mfn_field_tablet',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size_mobile_v2',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'custombgsize_mobile', 'opt' => 'is', 'val' => 'custom' ),
					'title' => __('Custom background size', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn-toggled mfn-custom-bg-size mfn_field_mobile',
				),



				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher disable-history',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:background-image_tablet',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:background-image_mobile',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'dynamic_data' => 'featured_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-image',
  			),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

				// Background Overlay WRAP

				array(
  				'class' => 'toggled_header',
					'title' => __('Background Overlay', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					'std' => '0',
				),

				array(
					'id' => 'background_overlay_switcher',
					'attr_id' => 'background_overlay_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-color',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:gradient',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-image',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-image_tablet',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-image_mobile',
  				'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-image',
  			),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-repeat',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-repeat_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-repeat_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-position',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-position_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-position_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-attachment',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-attachment_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-attachment_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-size',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-size_tablet',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:background-size_mobile',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:filter',
					'condition' => array( 'id' => 'background_overlay_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'css_filters',
					'label_after' => '<a name="reset-css-filters" href="#" class="mfn-option-btn mfn-option-blank btn-medium reset-css-filters" data-tooltip="Reset"><span class="mfn-icon mfn-icon-reset"></span></a><a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
					'class' => 'mfn-toggled toggle_fields',
					'title' => __('CSS Filters', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner .mcb-wrap-background-overlay:transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover .mcb-wrap-background-overlay:opacity',
					'type' => 'sliderbar',
					'title' => __('Opacity', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '1',
						'step' => '0.01',
					),
					//'std' => '1',
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover .mcb-wrap-background-overlay:background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover .mcb-wrap-background-overlay:gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover .mcb-wrap-background-overlay:background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				//'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

				array(
					'class' => 'toggled_header',
						'title' => __('Border', 'mfn-opts'),
					),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-style',
					'attr_id' => 'border_style_wrap',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-color',
					'condition' => array( 'id' => 'border_style_wrap', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-width',
  				'condition' => array( 'id' => 'border_style_wrap', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-width_tablet',
  				'condition' => array( 'id' => 'border_style_wrap', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-width_mobile',
  				'condition' => array( 'id' => 'border_style_wrap', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:box-shadow_tablet',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:box-shadow_mobile',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

				array(
					'class' => 'toggled_header',
					'title' => __('Responsive', 'mfn-opts'),
				),

				array(
  				'id' => 'visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'options' => array(
  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'active_tooltip' => array(
  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'visual_options' => array(
  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'reverse_order',
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'iconinfo' => 'https://support.muffingroup.com/how-to/how-to-reverse-the-order-of-elements-on-mobile/',
  				'title' => __('Order on mobile', 'mfn-opts'),
					'options' => [
						0 => __('Default', 'mfn-opts'),
						1 => __('Reverse rows', 'mfn-opts'),
						2 => __('Reverse columns', 'mfn-opts'),
					],
					'std' => 0,
  			),

				array(
					'class' => 'toggled_header',
					'title' => __('Custom', 'mfn-opts'),
				),

				array(
  				'id' => 'classes',
  				'oldid' => 'class',
  				'class' => 'mfn-toggled',
  				'type' => 'pills',
  				'title' => __('Classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_id',
  				'class' => 'mfn-toggled',
  				'type' => 'text',
  				'title' => __('ID', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_css',
  				'oldid' => 'style',
  				'class' => 'mfn-toggled',
  				'type' => 'textarea',
  				'title' => __('Additional CSS', 'mfn-opts'),
  			),

				// animation

				array(
					'form' => 'advanced',
					'class' => 'toggled_header',
					'title' => __('Animation', 'mfn-opts'),
				),

				array(
					'form' => 'advanced',
					'id' => 'animate',
					'attr_id' => 'wrap-animate',
					'type' => 'select',
					'title' => __('Animation', 'mfn-opts'),
					'desc' => __('Entrance animation', 'mfn-opts'),
					'class' => 'mfn-toggled',
					'options' => $this->get_animations(),
				),

				array(
					'form' => 'advanced',
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:animation-delay',
					'condition' => array( 'id' => 'wrap-animate', 'opt' => 'isnt', 'val' => '' ),
					'type' => 'sliderbar',
					'class' => 'mfn-toggled',
					'title' => __('Animation delay', 'mfn-opts'),
					'after' => 'ms',
					'param' => array(
						'min' => '0',
						'max' => '3000',
						'step' => '1',
						'unit' => 'ms'
					),
				),

				// global wraps

				array(
					'id' => 'global_wraps',
					'class' => 'toggled_header global_wraps',
					'title' => __('Global Wraps', 'mfn-opts'),
				),

				array(
					'id' => 'global_wraps_select',
					'attr_id' => 'global_wraps_select',
					'class' => 'mfn-toggled',
					'type' => 'select',
					'title' => __('Select template', 'mfn-opts'),
					'std' => '',
					'js_options' => 'global_wraps',
					'options' => mfna_templates('wrap'),
				),

				array(
					'type' => 'html',
					'html' => '</div>',
				),

  		);

  	}

    /**
     * SET items and their fields
   	 */

   	private function set_items(){

   		$this->items = array(

   			// Popup Exit popup exit_popup exit-button ----------------------------------------------------

   			'popup_exit' => array(
   				'type' => 'popup_exit',
   				'title' => __('Exit link', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'popup',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'label',
   						'edit_tag' => '.exit-mfn-popup | span.button_label',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Label', 'mfn-opts'),
   						'std' => __('Close popup', 'mfn-opts'),
   					),

						array(
							'id' => 'icon',
							'type' => 'icon',
							'title' => __('Icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'icon-cancel'
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Overrides icon', 'mfn-opts'),
							'preview' => 'image',
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Link', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'center',
						),


						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:--mfn-exitbutton-item-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:--mfn-exitbutton-item-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:--mfn-exitbutton-item-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-style',
							'attr_id' => 'border_exit_popup',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-width',
		  				'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-width_tablet',
		  				'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-width_mobile',
		  				'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),






						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup:border-color',
							'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup|hover:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup|hover:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a.exit-mfn-popup|hover:border-color',
							'condition' => array( 'id' => 'border_exit_popup', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

   			// Footer Logo ----------------------------------------------------

   			'footer_logo' => array(
   				'type' => 'footer_logo',
   				'title' => __('Logo', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'footer',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Logo', 'mfn-opts'),
   						'desc' => __('Recommended svg', 'mfn-opts'),
							'std' => mfn_opts_get('logo-img') ? mfn_opts_get('logo-img') : $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
							'id' => 'link',
							'type' => 'text',
							'title' => __('Link', 'mfn-opts'),
							'std' => '/',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'info',
							'type' => 'info',
							'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Footer Menu ----------------------------------------------------

   			'footer_menu' => array(
   				'type' => 'footer_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'footer',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							'options' => mfna_menu(),
							'js_options' => 'menus',
   					),

   					array(
   						'id' => 'menu_style',
   						'attr_id' => 'menu_style',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
							'options' => array(
								'vertical' => __('Vertical', 'mfn-opts'),
								'horizontal' => __('Horizontal', 'mfn-opts'),
							),
							'std' => 'vertical'
   					),


   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-vertical:text-align',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'vertical' ),
							'attr_id' => 'menu-items-alignment',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-vertical:text-align_tablet',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'vertical' ),
							'attr_id' => 'menu-items-alignment-tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-vertical:text-align_mobile',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'vertical' ),
							'attr_id' => 'menu-items-alignment-mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'center',
						),


   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-horizontal:justify-content',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'attr_id' => 'menu-items-alignment',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-horizontal:justify-content_tablet',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'attr_id' => 'menu-items-alignment-tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner ul.mfn-footer-menu-style-horizontal:justify-content_mobile',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'attr_id' => 'menu-items-alignment-mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'center',
						),



						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Menu', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul a|hover:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul .current-menu-item > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

   			// Mega menu Menu ----------------------------------------------------

   			'megamenu_menu' => array(
   				'type' => 'megamenu_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'megamenu',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							'options' => mfna_menu(),
							'js_options' => 'menus',
   					),

   					array(
   						'id' => 'menu_style',
   						'attr_id' => 'menu_style',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
							'options' => array(
								'vertical' => __('Vertical', 'mfn-opts'),
								'horizontal' => __('Horizontal', 'mfn-opts'),
							),
							'std' => 'vertical'
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal:justify-content',
							'attr_id' => 'menu-items-alignment',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal:justify-content_tablet',
							'attr_id' => 'menu-items-alignment-tablet',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal:justify-content_mobile',
							'attr_id' => 'menu-items-alignment-mobile',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal > li:flex-grow',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal > li:flex-grow_tablet',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu.mfn-mm-menu-horizontal > li:flex-grow_mobile',
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),

						array(
							'id' => 'submenu_on',
							'attr_id' => 'submenu_on',
							're_render' => true,
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'vertical' ),
							'type' => 'switch',
							'title' => __('Submenu visibility', 'mfn-opts'),
							'options' => array(
								'visible' => 'Visible',
								'toggled' => 'Toggled',
							),
							'std' => 'visible',
						),

						array(
							'id' => 'submenu_hori_on',
							're_render' => true,
							'condition' => array( 'id' => 'menu_style', 'opt' => 'is', 'val' => 'horizontal' ),
							'type' => 'switch',
							'title' => __('Submenu visibility', 'mfn-opts'),
							'options' => array(
								'hover' => 'on Hover',
								'click' => 'on Click',
							),
							'std' => 'hover',
						),

   					array(
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a .menu-icon:display',
							'attr_id' => 'icon_mm_visibility',
							'type' => 'switch',
							'title' => __('Icon visibility', 'mfn-opts'),
							'options' => array(
								'block' => 'Show',
								'none' 	=> 'Hide',
							),
							'std' => 'block',
						),

						array(
   						'id' => 'icon_align',
   						//'condition' => array( 'id' => 'icon_mm_visibility', 'opt' => 'is', 'val' => 'block' ),
   						'type' => 'switch',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'top' => 'Top',
								'right' => 'Right'
							),
							'std' => 'left'
   					),

						array(
   						'id' => 'icon_animation',
   						//'condition' => array( 'id' => 'icon_mm_visibility', 'opt' => 'is', 'val' => 'block' ),
   						'type' => 'select',
   						'title' => __('Icon animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
							'title' => __('Submenu', 'mfn-opts'),
						),

   					array(
							'id' => 'submenu',
							'attr_id' => 'submenu',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Submenu', 'mfn-opts'),
							'options' => array(
								'on' => 'Show',
								'off' => 'Hide',
							),
							'std' => 'on',
						),

						array(
   						'id' => 'submenu_animation',
   						'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
   						'type' => 'select',
   						'title' => __('Submenu Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'fade-in' => 'Fade In',
								'fade-up' => 'Fade In Up'
							),
   					),

						array(
							'id' => 'submenu_icon',
							'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-down'
						),

						array(
   						'id' => 'submenu_icon_animation',
   						'type' => 'select',
   						'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
   						'title' => __('Icon Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
							'title' => __('Desc', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a .menu-desc:display',
							'type' => 'switch',
							'title' => __('Desc visibility', 'mfn-opts'),
							'options' => array(
								'block' => 'Show',
								'none' 	=> 'Hide',
							),
							'std' => 'block',
						),

						array(
							'title' => __('Decoration icon', 'mfn-opts'),
						),

						array(
							'id' => 'decoration_icon',
							'type' => 'icon',
							'title' => __('Decoration icon', 'mfn-opts'),
							'preview' => 'icon',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Menu', 'mfn-opts'),
   					),

   					array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-style',
							'attr_id' => 'border_style_header_mm_menu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-width',
		  				'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a:border-color',
							'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a|hover:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a|hover:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a|hover:border-color',
							'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .current-menu-item > li > a:border-color',
							'condition' => array( 'id' => 'border_style_header_mm_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-gap',
							'type' => 'sliderbar',
							//'condition' => array( 'id' => 'icon_visibility', 'opt' => 'is', 'val' => 'block' ),
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-gap_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-gap_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu .menu-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu a|hover > .menu-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a > .menu-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-submenu-icon-gap',
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-submenu-icon-gap_tablet',
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-menu-submenu-icon-gap_mobile',
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li .menu-sub i:--mfn-megamenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li .menu-sub i:--mfn-megamenu-submenu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li .menu-sub i:--mfn-megamenu-submenu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a|hover .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'submenu', 'opt' => 'is', 'val' => 'on' ),
   						'title' => __('Submenu', 'mfn-opts'),
   					),

   					array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li > ul:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li > ul:border-style',
							'attr_id' => 'border_style_header_submenu',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:border-color',
							'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul:--mfn-megamenu-submenu-border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'version' => 'separated-fields',
							'css_attr' => 'border-radius',
						),

   					array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul a|hover:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul .current-menu-item > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-submenu-subicon-gap',
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-submenu-subicon-gap_tablet',
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li:--mfn-megamenu-submenu-subicon-gap_mobile',
							//'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-icon i:--mfn-megamenu-submenu-subicon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-icon i:--mfn-megamenu-submenu-subicon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-icon i:--mfn-megamenu-submenu-subicon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li > a|hover .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu > li.current-menu-item > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-sub i:--mfn-megamenu-submenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-sub i:--mfn-megamenu-submenu-submenu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul li .menu-sub i:--mfn-megamenu-submenu-submenu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li > a|hover .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li ul > li.current-menu-item > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Decoration icon', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li|hover > a > .decoration-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li.current-menu-item > a .decoration-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-megamenu-menu li a .decoration-icon i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),
						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
   			),

   			// Logo ----------------------------------------------------

   			'header_logo' => array(
   				'type' => 'header_logo',
   				'title' => __('Logo', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'dynamic_data' => 'featured_image',
   						'title' => __('Logo', 'mfn-opts'),
   						'desc' => __('Recommended svg', 'mfn-opts'),
							'std' => mfn_opts_get('logo-img') ? mfn_opts_get('logo-img') : $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
							'id' => 'link',
							'type' => 'text',
							'title' => __('Link', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .logo-wrapper:align-items',
							'type' => 'switch',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Vertical align', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Top',
								'center' => 'Center',
								'flex-end' => 'Bottom',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .logo-wrapper:align-items_tablet',
							'type' => 'switch',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Vertical align', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .logo-wrapper:align-items_mobile',
							'type' => 'switch',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Vertical align', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

			// Menu ----------------------------------------------------

   			'header_menu' => array(
   				'type' => 'header_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							'options' => mfna_menu(),
							'js_options' => 'menus',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu:justify-content',
							'attr_id' => 'menu-items-alignment',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'flex-end',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu:justify-content_tablet',
							'attr_id' => 'menu-items-alignment-tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu:justify-content_mobile',
							'attr_id' => 'menu-items-alignment-mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Left',
								'center' => 'Center',
								'flex-end' => 'Right',
								'space-between' => 'Space between',
								'space-around' => 'Space around',
								'space-evenly' => 'Space evenly',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:flex-grow',
							'condition' => array( 'id' => 'menu-items-alignment', 'opt' => 'is', 'val' => array('space-between', 'space-around', 'space-evenly') ),
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:flex-grow_tablet',
							'condition' => array( 'id' => 'menu-items-alignment-tablet', 'opt' => 'is', 'val' => array('space-between', 'space-around', 'space-evenly') ),
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:flex-grow_mobile',
							'condition' => array( 'id' => 'menu-items-alignment-mobile', 'opt' => 'is', 'val' => array('space-between', 'space-around', 'space-evenly') ),
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Fit container', 'mfn-opts'),
							'options' => [
								'unset' => __('Default', 'mfn-opts'),
								'1' => __('Fit', 'mfn-opts'),
							],
						),

   					array(
   						'id' => 'animation',
   						'attr_id' => 'header_menu_animation',
   						'type' => 'select',
   						'title' => __('Item Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'text-line-bottom' => __('Text line bottom', 'mfn-opts'),
								'text-toggle-line-bottom' => __('Text toggle line bottom', 'mfn-opts'),
								'toggle-line-bottom' => __('Toggle line bottom', 'mfn-opts'),
								'toggle-line-top' => __('Toggle line top', 'mfn-opts'),
								'text-bg-line' => __('Text bg line', 'mfn-opts'),
								'bg-left' => __('Bg left', 'mfn-opts'),
							),
   					),

   					array(
   						'id' => 'separator',
   						'attr_id' => 'menu_separator',
   						'type' => 'switch',
   						'title' => __('Separator', 'mfn-opts'),
							'options' => array(
								'off' => 'Off',
								'on' => 'On'
							),
							'std' => 'off'
   					),

   					array(
   						'id' => 'submenu_display',
   						'type' => 'switch',
   						'title' => __('Display submenu on', 'mfn-opts'),
							'options' => array(
								'hover' => 'Hover',
								'click' => 'Click'
							),
							'std' => 'hover'
   					),

   					array(
   						'id' => 'submenu_icon_display',
   						'attr_id' => 'submenu_icon_display',
   						'type' => 'switch',
   						'title' => __('Submenu Icon', 'mfn-opts'),
							'options' => array(
								'' => 'Off',
								'on' => 'On'
							),
							'std' => 'on'
   					),

   					array(
							'id' => 'submenu_icon',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-down'
						),

						array(
   						'id' => 'submenu_animation',
   						'type' => 'select',
   						'title' => __('Submenu Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'fade-in' => 'Fade In',
								'fade-up' => 'Fade In Up'
							),
   					),

						array(
							'id' => 'submenu_fold_to_right',
							'type' => 'switch',
							'title' => __('Submenu fold last two items to left', 'mfn-opts'),
							'options' => array(
								0 => __('Disable', 'mfn-opts'),
								1 => __('Enable', 'mfn-opts'),
							),
						),

   					array(
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
   						'id' => 'icon_align',
   						'type' => 'switch',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'top' => 'Top',
								'right' => 'Right'
							),
							'std' => 'left'
   					),

						array(
   						'id' => 'icon_animation',
   						'type' => 'select',
   						'title' => __('Icon animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

						array(
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'title' => __('Submenu', 'mfn-opts'),
						),

   					array(
							'id' => 'submenu_subicon',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-right'
						),

						array(
   						'id' => 'submenu_icon_animation',
   						'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
   						'type' => 'select',
   						'title' => __('Icon Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-gap',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-gap_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-gap_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-style',
							'attr_id' => 'border_style_header_menu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-width',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li|hover > a.mfn-menu-link:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item > a.mfn-menu-link:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-gap',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-gap_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-gap_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu .mfn-menu-item-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu a.mfn-menu-link|hover > .mfn-menu-item-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link > .mfn-menu-item-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-submenu-icon-gap',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-submenu-icon-gap_tablet',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-submenu-icon-gap_mobile',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li .mfn-menu-subicon i:--mfn-header-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li .mfn-menu-subicon i:--mfn-header-submenu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li .mfn-menu-subicon i:--mfn-header-submenu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link .mfn-menu-subicon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li > a.mfn-menu-link|hover .mfn-menu-subicon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link .mfn-menu-subicon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



						array(
							'class' => 'toggled_header',
							'title' => __('Submenu', 'mfn-opts'),
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:width',
							'type' => 'text',
							'class' => 'mfn-toggled mfn_field_desktop',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:width_tablet',
							'type' => 'text',
							'class' => 'mfn-toggled mfn_field_tablet',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:width_mobile',
							'type' => 'text',
							'class' => 'mfn-toggled mfn_field_mobile',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li > ul.mfn-submenu:border-style',
							'attr_id' => 'border_style_header_submenu',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:border-color',
							'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu:--mfn-header-submenu-border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'version' => 'separated-fields',
							'css_attr' => 'border-radius',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),




		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-style',
							'attr_id' => 'border_style_header_submenu_links',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu_links', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_submenu_links', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_submenu_links', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-color',
							'condition' => array( 'id' => 'border_style_header_submenu_links', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),







		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link|hover:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link|hover:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.current-menu-item.mfn-menu-li > a.mfn-menu-link:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.current-menu-item.mfn-menu-li > a.mfn-menu-link:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-gap',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-gap_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-gap_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li:--mfn-header-submenu-subicon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-item-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li a.mfn-menu-link:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li|hover > a.mfn-menu-link > .mfn-menu-item-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li|hover > a.mfn-menu-link:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link > .mfn-menu-item-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-sub-subicon i:--mfn-header-submenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-sub-subicon i:--mfn-header-submenu-submenu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu li.mfn-menu-li .mfn-menu-sub-subicon i:--mfn-header-submenu-submenu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.mfn-menu-li > a.mfn-menu-link .mfn-menu-sub-subicon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.mfn-menu-li > a.mfn-menu-link|hover .mfn-menu-sub-subicon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu li.mfn-menu-li ul.mfn-submenu > li.current-menu-item.mfn-menu-li > a.mfn-menu-link .mfn-menu-sub-subicon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'menu_separator', 'opt' => 'is', 'val' => 'on' ),
							'title' => __('Separator', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-sep',
							'condition' => array( 'id' => 'menu_separator', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
							'title' => __('Animation', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-animation-color',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-menu-animation-height',
							'type' => 'sliderbar',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'is', 'val' => array('text-line-bottom', 'text-toggle-line-bottom', 'toggle-line-bottom', 'toggle-line-top') ),
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '1',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Dropdown pointer', 'mfn-opts'),
						),

						array(
   						'id' => 'dropdown_pointer',
   						'attr_id' => 'dropdown_pointer',
   						'type' => 'switch',
   						'class' => 'mfn-toggled',
   						'title' => __('Visibility', 'mfn-opts'),
							'options' => array(
								'' => 'Hide',
								'1' => 'Show',
							),
							'std' => ''
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-submenu-dropdown-size',
							'type' => 'sliderbar',
							'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '1',
								'max' => '40',
								'step' => '1',
								'unit' => 'px',
							)
						),

   					array(
   						'id' => 'dropdown_alignment',
   						'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
   						'type' => 'switch',
   						'class' => 'mfn-toggled',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'std' => 'left'
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-submenu-dropdown-offset',
							'type' => 'sliderbar',
							'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
							'title' => __('Offset', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '1',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-menu > li.mfn-menu-li:--mfn-header-submenu-dropdown-color',
							'condition' => array( 'id' => 'dropdown_pointer', 'opt' => 'is', 'val' => '1' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),


				// Header menu burger ----------------------------------------------------

   			'header_burger' => array(
   				'type' => 'header_burger',
   				'title' => __('Menu burger', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						// icon

						array(
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'icon',
							'attr_id' => 'header_icon_font',
							'type' => 'icon',
							'title' => __('Icon', 'mfn-opts'),
							'preview' => 'icon',
						),

						array(
							'id' => 'image',
							'type' => 'upload',
							'title' => __('Image', 'mfn-opts'),
							'desc' => __('Image instead of an icon', 'mfn-opts'),
							'preview' => 'image',
						),

						array(
							'id' => 'desc',
							'type' => 'text',
							'edit_tag' => '.mfn-header-menu-burger | div.desc-wrapper',
   						'edit_position' => 'append',
							'title' => __('Desc', 'mfn-opts'),
						),


						// sidebar

						array(
							'title' => __('Sidebar', 'mfn-opts'),
						),

   					array(
							'class' => 'mfn-builder-subheader',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Menu to display', 'mfn-opts'),
							'options' => mfna_menu(),
							'js_options' => 'menus',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper:align-items',
							'type' => 'select',
							'title' => __('Vertical align', 'mfn-opts'),
							'options' => array(
								'flex-start' => 'Top',
								'center' => 'Center',
								'flex-end' => 'Bottom',
							),
							'std' => 'center'
						),

   					array(
   						'id' => 'menu_pos',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Sidebar position', 'mfn-opts'),
							'options' => array(
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'right'
   					),

   					array(
   						'id' => 'animation',
   						'attr_id' => 'header_menu_animation',
   						'type' => 'select',
   						'title' => __('Item Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'text-line-bottom' => __('Text line bottom', 'mfn-opts'),
								'text-toggle-line-bottom' => __('Text toggle line bottom', 'mfn-opts'),
								'toggle-line-bottom' => __('Toggle line bottom', 'mfn-opts'),
								'toggle-line-top' => __('Toggle line top', 'mfn-opts'),
								'text-bg-line' => __('Text bg line', 'mfn-opts'),
								'bg-left' => __('Bg left', 'mfn-opts'),
							),
   					),

   					array(
   						'id' => 'submenu_icon_display',
   						'attr_id' => 'submenu_icon_display',
   						'type' => 'switch',
   						'title' => __('Submenu Icon', 'mfn-opts'),
							'options' => array(
								'' => 'Off',
								'on' => 'On'
							),
							'std' => 'on'
   					),

   					array(
   						'id' => 'submenu_animation',
   						'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
   						'type' => 'select',
   						'title' => __('Submenu Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'fade-in' => 'Fade In',
								'fade-up' => 'Fade In Up'
							),
   					),

   					array(
							'id' => 'submenu_icon',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-down'
						),

						array(
   						'id' => 'menu_icon_align',
   						'attr_id' => 'menu_icon_align',
   						'type' => 'switch',
   						'title' => __('Icon align', 'mfn-opts'),
							'options' => array(
								'left' => 'Left',
								'top' => 'Top',
								'right' => 'Right'
							),
							'std' => 'left'
   					),

						array(
   						'id' => 'icon_animation',
   						'type' => 'select',
   						'title' => __('Icon animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

						array(
   						'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'class' => 'mfn-builder-subheader',
							'title' => __('Submenu', 'mfn-opts'),
						),

   					array(
							'id' => 'submenu_subicon',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'icon',
							'title' => __('Submenu icon', 'mfn-opts'),
							'preview' => 'icon',
							'std' => 'fas fa-arrow-right'
						),

						array(
   						'id' => 'submenu_icon_animation',
   						'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
   						'type' => 'select',
   						'title' => __('Icon Animation', 'mfn-opts'),
							'options' => array(
								'' => __('None', 'mfn-opts'),
								'rotate' => 'Rotate',
								'zoom' => 'Zoom'
							),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'icon_position',
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'top',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
						),

						array(
							'id' => 'icon_position_tablet',
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
						),

						array(
							'id' => 'icon_position_mobile',
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
						),

						array(
							'id' => 'icon_align',
							'type' => 'switch',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
							),
							'std' => 'center',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
						),

						array(
							'id' => 'icon_align_tablet',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
						),

						array(
							'id' => 'icon_align_mobile',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-style',
							'attr_id' => 'border_style_header_icon',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-width',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'class' => 'toggled_header',
							'title' => __('Desc', 'mfn-opts'),
						),

						array(
		  				'id' => 'header_icon_desc_visibility',
		  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
		  				'type' => 'switch',
		  				'invert' => true,
		  				'version' => 'multiple',
		  				'class' => 'mfn-toggled',
		  				'title' => __('Responsive visibility', 'mfn-opts'),
		  				'options' => array(
		  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),
		  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),
		  				),
		  				'active_tooltip' => array(
		  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
		  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
		  				),
		  				'visual_options' => array(
		  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
		  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
		  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
		  				),
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc-wrapper:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .desc-wrapper:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .desc-wrapper:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Sidebar', 'mfn-opts'),
						),


						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:--mfn-header-menu-sidebar-width',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '100',
								'max' => '1920',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:--mfn-header-menu-sidebar-width_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '100',
								'max' => '1920',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:--mfn-header-menu-sidebar-width_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '100',
								'max' => '1920',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-tmpl-menu-sidebar-wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'bg_menu-tmpl-sidebar',
							'type' => 'switch',
							'class' => 'mfn-toggled mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-color',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:gradient',
		  				'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-image',
		  				'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
		  				'oldid' => 'bg_color',
		  				'type' => 'upload',
		  				'title' => __('Image', 'mfn-opts'),
		  				'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'background-image',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-image_tablet',
		  				'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
		  				'oldid' => 'bg_image',
		  				'type' => 'upload',
		  				'title' => __('Image', 'mfn-opts'),
		  				'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'background-image',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-image_mobile',
		  				'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
		  				'type' => 'upload',
		  				'title' => __('Image', 'mfn-opts'),
		  				'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'background-image',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-repeat',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'background-repeat',
							'title' => __('Repeat', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'repeat' => __('Repeat', 'mfn-opts'),
								'no-repeat' => __('No repeat', 'mfn-opts'),
								'repeat-x' => __('Repeat X', 'mfn-opts'),
								'repeat-y' => __('Repeat Y', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-repeat_tablet',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'background-repeat',
							'title' => __('Repeat', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'repeat' => __('Repeat', 'mfn-opts'),
								'no-repeat' => __('No repeat', 'mfn-opts'),
								'repeat-x' => __('Repeat X', 'mfn-opts'),
								'repeat-y' => __('Repeat Y', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-repeat_mobile',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'background-repeat',
							'title' => __('Repeat', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'repeat' => __('Repeat', 'mfn-opts'),
								'no-repeat' => __('No repeat', 'mfn-opts'),
								'repeat-x' => __('Repeat X', 'mfn-opts'),
								'repeat-y' => __('Repeat Y', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-position',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'oldid' => 'bg_position',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'background-position',
							'title' => __('Position', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'center' => __('Center Center', 'mfn-opts'),
								'center left' => __('Center Left', 'mfn-opts'),
								'center right' => __('Center Right', 'mfn-opts'),
								'top left' => __('Top Left', 'mfn-opts'),
								'top right' => __('Top Right', 'mfn-opts'),
								'top center' => __('Top Center', 'mfn-opts'),
								'bottom left' => __('Bottom Left', 'mfn-opts'),
								'bottom right' => __('Bottom Right', 'mfn-opts'),
								'bottom center' => __('Bottom Center', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-position_tablet',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'oldid' => 'bg_position',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'background-position',
							'title' => __('Position', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'center' => __('Center Center', 'mfn-opts'),
								'center left' => __('Center Left', 'mfn-opts'),
								'center right' => __('Center Right', 'mfn-opts'),
								'top left' => __('Top Left', 'mfn-opts'),
								'top right' => __('Top Right', 'mfn-opts'),
								'top center' => __('Top Center', 'mfn-opts'),
								'bottom left' => __('Bottom Left', 'mfn-opts'),
								'bottom right' => __('Bottom Right', 'mfn-opts'),
								'bottom center' => __('Bottom Center', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-position_mobile',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'oldid' => 'bg_position',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'background-position',
							'title' => __('Position', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'center' => __('Center Center', 'mfn-opts'),
								'center left' => __('Center Left', 'mfn-opts'),
								'center right' => __('Center Right', 'mfn-opts'),
								'top left' => __('Top Left', 'mfn-opts'),
								'top right' => __('Top Right', 'mfn-opts'),
								'top center' => __('Top Center', 'mfn-opts'),
								'bottom left' => __('Bottom Left', 'mfn-opts'),
								'bottom right' => __('Bottom Right', 'mfn-opts'),
								'bottom center' => __('Bottom Center', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-attachment',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'background-attachment',
							'title' => __('Attachment', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'scroll' => __('Scroll', 'mfn-opts'),
								'fixed' => __('Fixed', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-attachment_tablet',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'background-attachment',
							'title' => __('Attachment', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'scroll' => __('Scroll', 'mfn-opts'),
								'fixed' => __('Fixed', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-attachment_mobile',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'background-attachment',
							'title' => __('Attachment', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'scroll' => __('Scroll', 'mfn-opts'),
								'fixed' => __('Fixed', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-size',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'oldid' => 'bg_size',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'background-size',
							'title' => __('Size', 'mfn-opts'),
							'options' => mfna_bg_size()
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-size_tablet',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'oldid' => 'bg_size',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'background-size',
							'title' => __('Size', 'mfn-opts'),
							'options' => mfna_bg_size()
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar:background-size_mobile',
							'condition' => array( 'id' => 'bg_menu-tmpl-sidebar', 'opt' => 'is', 'val' => 'default' ),
							'oldid' => 'bg_size',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'background-size',
							'title' => __('Size', 'mfn-opts'),
							'options' => mfna_bg_size()
						),
						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Close', 'mfn-opts'),
						),

						array(
							'id' => 'sidebar-menu-close-icon-position',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Position', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),










						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-close-icon:font-size',
							'type' => 'sliderbar',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'param' => array(
								'min' => '0',
								'max' => '40',
								'step' => '1',
								'unit' => 'px',
							),
							'std' => '20px'
						),












						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu-toggle .icon:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Content overlay', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement.mfn-header-tmpl-menu-active|before:display',
							'type' => 'switch',
							'title' => __('Visibility', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'options' => [
								'' => __('Hidden', 'mfn-opts'),
								'block' => __('Visible', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement.mfn-header-tmpl-menu-active|before:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Menu', 'mfn-opts'),
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'id' => 'items_align',
							'condition' => array( 'id' => 'menu_icon_align', 'opt' => 'isnt', 'val' => 'top' ),
							'type' => 'switch',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'top',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
						),

						array(
							'id' => 'items_align_tablet',
							'condition' => array( 'id' => 'menu_icon_align', 'opt' => 'isnt', 'val' => 'top' ),
							'type' => 'switch',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
						),

						array(
							'id' => 'items_align_mobile',
							'condition' => array( 'id' => 'menu_icon_align', 'opt' => 'isnt', 'val' => 'top' ),
							'type' => 'switch',
							'title' => __('Alignment', 'mfn-opts'),
							'options' => array(
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-gap',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-gap_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-gap_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-style',
							'attr_id' => 'border_style_header_menu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-width',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li|hover > a:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:border-color',
							'condition' => array( 'id' => 'border_style_header_menu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Animation', 'mfn-opts'),
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-menu-li > .mfn-menu-link .label-wrapper|before:--mfn-header-menu-animation-color',
							'condition' => array( 'id' => 'header_menu_animation', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-gap',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-gap_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-gap_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu .menu-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu a|hover > .menu-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a > .menu-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-submenu-icon-gap',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-submenu-icon-gap_tablet',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li:--mfn-header-menu-submenu-icon-gap_mobile',
							'condition' => array( 'id' => 'submenu_icon_display', 'opt' => 'is', 'val' => 'on' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .menu-sub i:--mfn-header-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .menu-sub i:--mfn-header-submenu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .menu-sub i:--mfn-header-submenu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li > a|hover .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu > li.current-menu-item > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),



						array(
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'sidebar_type', 'opt' => 'is', 'val' => 'default' ),
							'title' => __('Submenu', 'mfn-opts'),
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul:border-style',
							'attr_id' => 'border_style_header_submenu',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul:border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul:border-color',
							'condition' => array( 'id' => 'border_style_header_submenu', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a|hover:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a|hover:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li:--mfn-header-submenu-subicon-gap',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li:--mfn-header-submenu-subicon-gap_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li:--mfn-header-submenu-subicon-gap_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Gap', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li:--mfn-header-submenu-subicon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li:--mfn-header-submenu-subicon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li:--mfn-header-submenu-subicon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul .menu-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li|hover > a > .menu-icon > i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li|hover > a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul > li.current-menu-item > a > .menu-icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul > li.current-menu-item > a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Submenu icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li .menu-sub i:--mfn-header-submenu-submenu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li .menu-sub i:--mfn-header-submenu-submenu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul li .menu-sub i:--mfn-header-submenu-submenu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Icon size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul > li > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul > li > a|hover .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li ul > li.current-menu-item > a .menu-sub i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Submenu', 'mfn-opts'),
						),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-style',
							'attr_id' => 'border_style_header_submenu_link',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-width',
		  				'condition' => array( 'id' => 'border_style_header_submenu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_header_submenu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_header_submenu_link', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-color',
							'condition' => array( 'id' => 'border_style_header_submenu_link', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'mfn-builder-subheader mfn-toggled',
							'title' => __('Items', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li|hover > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li|hover > a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li.current-menu-item > a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-tmpl-menu-sidebar .mfn-header-menu li .mfn-submenu li.current-menu-item > a:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						// advanced here

   				),
   			),

				// Header icon ----------------------------------------------------

   			'header_icon' => array(
   				'type' => 'header_icon',
   				'title' => __('Icon', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						// icon

						array(
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'type',
							'attr_id' => 'header_icon_type',
							're_render' => true,
							'type' => 'select',
							'title' => __('Icon type', 'mfn-opts'),
							'options' => array(
								'tel' => 'Phone',
								'mail' => 'E-mail',
								'search' => 'Search',
								'default' => 'Custom',
								'cart' => 'Shop cart',
								'account' => 'My account',
								'wishlist' => 'Wishlist',
							),
							'desc' => __('For icons: Shop cart, My account and Wishlist, woocommerce plugin is required', 'mfn-opts'),
							'std' => 'tel',
						),

						array(
							'id' => 'icon',
							'attr_id' => 'header_icon_font',
							'type' => 'icon',
							'title' => __('Icon', 'mfn-opts'),
							'preview' => 'icon',
						),

						array(
							'id' => 'image',
							'type' => 'upload',
							'title' => __('Image', 'mfn-opts'),
							'desc' => __('Image instead of an icon', 'mfn-opts'),
							'preview' => 'image',
						),

						// link

						array(
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'tel,mail,default,cart,wishlist,search' ),
							'title' => __('Additional', 'mfn-opts'),
						),

						array(
							'id' => 'desc',
							'attr_id' => 'header-icon-desc',
							'type' => 'text',
							'edit_tag' => '.mfn-header-icon-box | div.desc-wrapper',
   						'edit_position' => 'append',
							'title' => __('Desc', 'mfn-opts'),
						),

						array(
							'id' => 'cart_total',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'cart' ),
							'type' => 'switch',
							're_render' => true,
							'title' => __('Cart total ', 'mfn-opts'),
							'options' => array(
								'0' => 'Hide',
								'1' => 'Show',
							),
							'std' => '1',
						),

						array(
							'id' => 'count',
							'attr_id' => 'header_icon_count',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => array('wishlist', 'cart') ),
							'type' => 'switch',
							're_render' => true,
							'title' => __('Icon count', 'mfn-opts'),
							'options' => array(
								'0' => 'Hide',
								'1' => 'Show',
							),
							'std' => '1',
						),

						array(
							'id' => 'link',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'tel,mail,default' ),
							'type' => 'text',
							'title' => __('Link', 'mfn-opts'),
						),

						array(
							'id' => 'target',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'tel,mail,default' ),
							'type' => 'select',
							'title' => __('Target', 'mfn-opts'),
							'options' => array(
								0 => __('Default | _self', 'mfn-opts'),
								1 => __('New tab or window | _blank', 'mfn-opts'),
							),
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'icon_position',
							//'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'desc' => __('Work with desc only', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							),
							'std' => 'top',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
						),

						array(
							'id' => 'icon_position_tablet',
							//'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'desc' => __('Work with desc only', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
						),

						array(
							'id' => 'icon_position_mobile',
							//'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon position', 'mfn-opts'),
							'desc' => __('Work with desc only', 'mfn-opts'),
							'options' => array(
								'top' => __('Top', 'mfn-opts'),
								'bottom' => __('Bottom', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
						),

						array(
							'id' => 'icon_align',
							'type' => 'switch',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
							),
							'std' => 'center',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
						),

						array(
							'id' => 'icon_align_tablet',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
						),

						array(
							'id' => 'icon_align_mobile',
							'condition' => array( 'id' => 'header-icon-desc', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'switch',
							'title' => __('Icon alignment', 'mfn-opts'),
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:--mfn-header-menu-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:width_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:height_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-style',
							'attr_id' => 'border_style_header_icon',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:border-width',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper:border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon-wrapper:--mfn-header-icon-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:border-color',
							'condition' => array( 'id' => 'border_style_header_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .icon-wrapper:--mfn-header-icon-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),


		  			array(
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'cart,wishlist' ),
							'title' => __('Icon count', 'mfn-opts'),
						),

						array(
							'id' => 'icon_count_posv',
							'attr_id' => 'icon_count_posv',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Vertical offset', 'mfn-opts'),
							'options' => array(
								'0' => __('Top', 'mfn-opts'),
								'1' => __('Bottom', 'mfn-opts'),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:top',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Top', 'mfn-opts'),
							'class' => 'mfn-toggled header-icon-vert-count mfn_field_desktop',
							'param' => array(
								'min' => '-50',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'default_value' => '-9px'
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:top_tablet',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Top', 'mfn-opts'),
							'class' => 'mfn-toggled header-icon-vert-count mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:top_mobile',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Top', 'mfn-opts'),
							'class' => 'mfn-toggled header-icon-vert-count mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:bottom',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Bottom', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop header-icon-vert-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:bottom_tablet',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Bottom', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet header-icon-vert-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:bottom_mobile',
							'condition' => array( 'id' => 'icon_count_posv', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Bottom', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile header-icon-vert-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'icon_count_posh',
							'attr_id' => 'icon_count_posh',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Horizontal offset', 'mfn-opts'),
							'options' => array(
								'0' => __('Left', 'mfn-opts'),
								'1' => __('Right', 'mfn-opts'),
							),
							'std' => '1'
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:right',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Right', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop header-icon-hori-count',
							'param' => array(
								'min' => '-50',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							),
							'default_value' => '-11px'
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:right_tablet',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Right', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet header-icon-hori-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:right_mobile',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '1' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Right', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile header-icon-hori-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:left',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Left', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop header-icon-hori-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:left_tablet',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Left', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet header-icon-hori-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:left_mobile',
							'condition' => array( 'id' => 'icon_count_posh', 'opt' => 'is', 'val' => '0' ),
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Left', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile header-icon-hori-count',
							'param' => array(
								'min' => '0',
								'max' => '100',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:color',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-cart-count,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .icon-wrapper .header-wishlist-count:background-color',
							'condition' => array( 'id' => 'header_icon_count', 'opt' => 'is', 'val' => '1' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
							'class' => 'toggled_header',
							'title' => __('Desc', 'mfn-opts'),
						),

						array(
		  				'id' => 'header_icon_desc_visibility',
		  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
		  				'type' => 'switch',
		  				'invert' => true,
		  				'version' => 'multiple',
		  				'class' => 'mfn-toggled',
		  				'title' => __('Responsive visibility', 'mfn-opts'),
		  				'options' => array(
		  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),
		  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),
		  				),
		  				'active_tooltip' => array(
		  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
		  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
		  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
		  				),
		  				'visual_options' => array(
		  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
		  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
		  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
		  				),
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc-wrapper:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box .desc-wrapper:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-icon-box|hover .desc-wrapper:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

			// Header search ----------------------------------------------------

   			'header_search' => array(
   				'type' => 'header_search',
   				'title' => __('Search field', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'title' => __('Input', 'mfn-opts'),
						),

						array(
							'id' => 'placeholder',
							'type' => 'text',
							'title' => __('Placeholder', 'mfn-opts'),
							'std' => __('Enter your search', 'betheme'),
						),

						array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Input', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input:border-style',
							'attr_id' => 'border_style_header_search',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:border-width',
							'condition' => array( 'id' => 'border_style_header_search', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'dimensions',
							'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'border-width',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:border-radius',
							'type' => 'dimensions',
							'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'border-radius',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),


		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:height',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '15',
								'max' => '80',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:height_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '15',
								'max' => '80',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:height_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Height', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '15',
								'max' => '80',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Font size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '70',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Font size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '70',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Font size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '70',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:--mfn-header-search-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field:border-color',
							'condition' => array( 'id' => 'border_style_header_search', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field|focus:--mfn-header-search-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field|focus:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement form input.field|focus:border-color',
							'condition' => array( 'id' => 'border_style_header_search', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'class' => 'toggled_header',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper:--mfn-header-search-icon-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper:--mfn-header-search-icon-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper:--mfn-header-search-icon-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper:--mfn-header-search-icon-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Size', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '5',
								'max' => '150',
								'step' => '1',
								'unit' => 'px',
							)
						),


						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper .icon_search:left',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'title' => __('Left offset', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_desktop',
							'param' => array(
								'min' => '0',
								'max' => '50',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper .icon_search:left_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'title' => __('Left offset', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_tablet',
							'param' => array(
								'min' => '0',
								'max' => '50',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .search_wrapper .icon_search:left_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'title' => __('Left offset', 'mfn-opts'),
							'class' => 'mfn-toggled mfn_field_mobile',
							'param' => array(
								'min' => '0',
								'max' => '50',
								'step' => '1',
								'unit' => 'px',
							)
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Header Promo Bar ----------------------------------------------------

   			'header_promo_bar' => array(
   				'type' => 'header_promo_bar',
   				'title' => __('Promo bar', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Slides', 'mfn-opts'),
							'options' => [
								'title' => [
									'textarea',
									__('Content', 'mfn-opts'),
									'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'std' => [
								0 => [
									'title' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'preview' => 'tabs',
							'primary' => 'title', // default
   					),

   					array(
   						'id' => 'slider_speed',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Autoplay speed', 'mfn-opts'),
   						'std' => '3',
   						'after' => 's',
   						'param' => 'number',
   						'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:color',
							'type' => 'color',
							'class' => 'mfn-toggled main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a:color',
							'type' => 'color',
							'class' => 'mfn-toggled main-color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner a|hover:color',
							'type' => 'color',
							'class' => 'mfn-toggled main-color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Shop Products ----------------------------------------------------

   			'shop_products' => array(
   				'type' => 'shop_products',
   				'title' => __('Shop products', 'mfn-opts'),
   				'desc' => __('List of products from woocommerce', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'shop-archive',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'products',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '12',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'layout',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Columns', 'mfn-opts'),
							'options' => array(
								'grid' => __('Grid, 3 columns', 'mfn-opts'),
								'grid col-4' => __('Grid, 4 columns', 'mfn-opts'),
								'masonry' => __('Masonry, 3 columns', 'mfn-opts'),
								'list' => __('List', 'mfn-opts'),
							),
   						'std' => 'grid',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'description',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
                'list' => __('List layout only', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'id' => 'button',
							're_render' => true,
							'type' => 'switch',
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
                'list' => __('List layout only', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						// order

						array(
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => true,
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						// HTML style

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					// HTML end: style

   					array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:text-align',
							'oldid' => 'style:li.product:text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-style',
							'attr_id' => 'border_style_shop_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-color',
							'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-style',
							'attr_id' => 'border_style_shopimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			// title

						array(
							'title' => __('Title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Desc', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color on Hover', 'mfn-opts'),
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Sale label', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'title' => __('Result count', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-result-count:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-result-count:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Sorting', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-style',
							'attr_id' => 'border_style_shop_order',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-width',
		  				'condition' => array( 'id' => 'border_style_shop_order', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shop_order', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shop_order', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-color',
							'condition' => array( 'id' => 'border_style_shop_order', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .woocommerce-ordering select:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'title' => __('List options', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options form.mfn-before-products-list-form:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop-filters .mfn-woo-list-options form.mfn-before-products-list-form:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating:display',
							'attr_id' => 'shop-list-rating',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Visibility', 'mfn-opts'),
							'options' => [
								'' => __('Visible', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => ''
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span:color',
							'condition' => array( 'id' => 'shop-list-rating', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Shop Title ----------------------------------------------------

   			'shop_title' => array(
   				'type' => 'shop_title',
   				'title' => __('Shop title', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'shop-archive',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// title

						array(
							'class' => 'toggled_header',
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product Title ----------------------------------------------------

   			'product_title' => array(
   				'type' => 'product_title',
   				'title' => __('Product title', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// title

						array(
							'class' => 'toggled_header',
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product images ----------------------------------------------------

   			'product_images' => array(
   				'type' => 'product_images',
   				'title' => __('Product images', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'zoom',
   						'type' => 'switch',
   						'title' => __('Zoom effect', 'mfn-opts'),
							'options' => array(
								'0' => __('Disable', 'mfn-opts'),
								'1' => __('Enable', 'mfn-opts'),
							),
   						'std' => '1',
   					),

   					array(
   						'title' => __('Arrows', 'mfn-opts'),
   					),

   					array(
   						'id' => 'thumbnail_arrows',
   						'attr_id' => 'thumbnail_arrows',
   						'type' => 'switch',
   						'title' => __('Arrows', 'mfn-opts'),
   						'desc' => __('Works with thumbnail horizontal styles', 'mfn-opts'),
							'options' => array(
								'' => __('Disable', 'mfn-opts'),
								'1' => __('Enable', 'mfn-opts'),
							),
   						'std' => '1',
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// image

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-style',
							'attr_id' => 'border_style_prodimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-color',
							'condition' => array( 'id' => 'border_style_prodimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-width',
		  				'condition' => array( 'id' => 'border_style_prodimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_prodimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_prodimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-viewport:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						// thumbnails

						array(
							'class' => 'toggled_header',
							'title' => __('Thumbnails', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-style',
							'attr_id' => 'border_style_prodthumbs',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-color',
							'condition' => array( 'id' => 'border_style_prodthumbs', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-width',
		  				'condition' => array( 'id' => 'border_style_prodthumbs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_prodthumbs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_prodthumbs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs li:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
							'condition' => array( 'id' => 'thumbnail_arrows', 'opt' => 'is', 'val' => '1' ),
							'title' => __('Thumbnails arrows', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:--mfn-swiper-arrow-size',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Arrow size', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
							'std' => '20px',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:--mfn-swiper-arrow-size_tablet',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Arrow size', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
							'std' => '20px',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:--mfn-swiper-arrow-size_mobile',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Arrow size', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
							'std' => '20px',
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-swiper-arrow|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),








   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product price ----------------------------------------------------

   			'product_price' => array(
   				'type' => 'product_price',
   				'title' => __('Product price', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Price', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Old price', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price > del:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price > del:color',
							'oldid' => 'style:.price > del:color',
							'type' => 'color',
							'class' => 'sales-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
							'desc' => __('Old price on sale', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product add to cart ----------------------------------------------------

   			'product_cart_button' => array(
   				'type' => 'product_cart_button',
   				'title' => __('Add to cart', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'cart_button_text',
							'type' => 'text',
							'title' => __('Button text', 'mfn-opts'),
							'std' => __('Add to cart', 'woocommerce'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr label:color',
							'type' => 'color',
							'class' => 'sales-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr label:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Line separator', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li><li><a href="#active" data-tab="active">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper .mfn-vr ul.mfn-vr-options li.active a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button:gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-product-add-to-cart .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Quantity', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity input.qty:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement .quantity a.quantity-change:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Plus/Minus color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product breadcrumbs ----------------------------------------------------

   			'product_breadcrumbs' => array(
   				'type' => 'product_breadcrumbs',
   				'title' => __('Breadcrumbs', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'title' => __('Custom', 'mfn-opts'),
						),

						array(
							'id' => 'breadcrumb_delimiter',
							'type' => 'text',
							're_render' => true,
							'title' => __('Delimiter', 'mfn-opts'),
							'std' => '/',
						),

						array(
							'id' => 'breadcrumb_home',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Home page', 'mfn-opts'),
							'options' => [
								'0' => 'No',
								'1' => 'Include',
							],
							'std' => '1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),


						array(
							'title' => __('Breadcrumbs', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Delimiter', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb span:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-woocommerce-breadcrumb span:opacity',
							'type' => 'sliderbar',
							'class' => 'mfn-toggled',
							'title' => __('Opacity', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '1',
								'step' => '0.1',
							),
							'std' => '0.2'
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product reviews ----------------------------------------------------

   			'product_reviews' => array(
   				'type' => 'product_reviews',
   				'title' => __('Product reviews', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-Reviews-title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Container', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__author:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Author name color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__published-date,.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta .woocommerce-review__dash:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Date color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text .description:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Comment color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #comments ol.commentlist li .comment-text p.meta:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Line color', 'mfn-opts'),
						),

						array(
							'title' => __('Stars', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating span,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a|before:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Form title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #respond .comment-reply-title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #respond .comment-reply-title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Your rating', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form label:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Label', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Number', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .comment-form-rating p.stars a:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Textarea', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea,.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea|focus:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement #reviews #review_form_wrapper .comment-form .comment-form-comment textarea:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-style',
							'attr_id' => 'border_style_prodrev',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-width',
		  				'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:border-color',
							'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input:gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:border-color',
							'condition' => array( 'id' => 'border_style_prodrev', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.woocommerce #Content .mcb-section .mcb-wrap .mcb-item-mfnuidelement #review_form #respond .form-submit input|hover:gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product rating ----------------------------------------------------

   			'product_rating' => array(
   				'type' => 'product_rating',
   				'title' => __('Product rating', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-review-link:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating span:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Active stars color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .star-rating|before:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Unactive stars color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-rating:text-align',
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-rating:text-align_tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-rating:text-align_mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),


   			// Product stock ----------------------------------------------------

   			'product_stock' => array(
   				'type' => 'product_stock',
   				'title' => __('Product stock', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('To display stock, please enable stock management at product level and set its quantity. This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Product stock', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock.in-stock:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('In stock color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock.out-of-stock:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Out of stock color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product meta ----------------------------------------------------

   			'product_meta' => array(
   				'type' => 'product_meta',
   				'title' => __('Product meta', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'title' => __('Options', 'mfn-opts'),
						),

						array(
							'id' => 'layout',
							'attr_id' => 'prod_meta_layout',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Layout', 'mfn-opts'),
							'options' => [
								'inline' => __('Inline', 'mfn-opts'),
								'stacked' => __('Stacked', 'mfn-opts'),
								'table' => __('Table', 'mfn-opts'),
							],
							'std' => 'inline',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Container', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta td:text-align',
							'oldid' => 'style:.product_meta, .product_meta th, .product_meta td:text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Stacked line color', 'mfn-opts'),
						),

						array(
							'title' => __('Label', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.tagged_as,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.stacked-meta-title,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta th:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.tagged_as,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.stacked-meta-title,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta th:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'title' => __('Value', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .table-meta td a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .stacked-categories span.stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta span.posted_in a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'title' => __('Tags', 'mfn-opts'),
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li.stacked-tags .stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .tagged_as a:color',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta .stacked-meta li.stacked-tags .stacked-meta-value a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .tagged_as a:background',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'title' => __('SKU', 'mfn-opts'),
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper:color',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper:background',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stacked-sku .stacked-meta-value,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn_product_meta .sku_wrapper:border-color',
							'condition' => array( 'id' => 'prod_meta_layout', 'opt' => 'isnt', 'val' => 'table' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product short_description ----------------------------------------------------

   			'product_short_description' => array(
   				'type' => 'product_short_description',
   				'title' => __('Short description', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Description', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:text-align_tablet',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:text-align_mobile',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product content ----------------------------------------------------

   			'product_content' => array(
   				'type' => 'product_content',
   				'title' => __('Product content', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'info',
							'type' => 'info',
							'title' => __('This element has no attributes. Please check <b>advanced</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product additional information ----------------------------------------------------

   			'product_additional_information' => array(
   				'type' => 'product_additional_information',
   				'title' => __('Additional information', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'title' => __('Options', 'mfn-opts'),
						),

						array(
							'id' => 'title',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title', 'mfn-opts'),
							'options' => [
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							],
							'std' => '1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Item title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement h3:text-align',
   						'type' => 'switch',
   						'class' => 'mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement h3:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement h3:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement h3:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement h3:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Content', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td:text-align',
							'oldid' => 'style:.woocommerce-product-attributes th, .woocommerce-product-attributes td:text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes th:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Value color', 'mfn-opts'),
						),

						array(
							'title' => __('Line', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement table.woocommerce-product-attributes td span|before:background',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						// HTML end: style

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product related ----------------------------------------------------

   			'product_related' => array(
   				'type' => 'product_related',
   				'title' => __('Product related', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'products',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						array(
   						'id' => 'columns',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Columns', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'button',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'description',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => true,
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Item title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:text-align_tablet',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:text-align_mobile',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-related > .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:text-align',
							'oldid' => 'style:li.product:text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-style',
							'attr_id' => 'border_style_shop_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-color',
							'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-style',
							'attr_id' => 'border_style_shopimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			// title

						array(
							'title' => __('Title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Desc', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color on Hover', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Sale label', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating:display',
							'attr_id' => 'shop-list-rating',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Visibility', 'mfn-opts'),
							'options' => [
								'' => __('Visible', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => ''
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span:color',
							'condition' => array( 'id' => 'shop-list-rating', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product upsells ----------------------------------------------------

   			'product_upsells' => array(
   				'type' => 'product_upsells',
   				'title' => __('Product upsells', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'products',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						array(
   						'id' => 'columns',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Columns', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'button',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'description',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => true,
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => true,
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'title' => __('Item title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_desktop mfn-toggled',
							'responsive' => 'desktop',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:text-align_tablet',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_tablet mfn-toggled',
							'responsive' => 'tablet',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:text-align_mobile',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'class' => 'mfn_field_mobile mfn-toggled',
							'responsive' => 'mobile',
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-upsells > .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:text-align',
							'oldid' => 'style:li.product:text-align',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-style',
							'attr_id' => 'border_style_shop_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-color',
							'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shop_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-style',
							'attr_id' => 'border_style_shopimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shopimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			// title

						array(
							'title' => __('Title', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'title' => __('Desc', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .excerpt:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Attributes', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a|hover:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color on Hover', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-variations-wrapper-loop .mfn-vr ul.mfn-vr-options li a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Sale label', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .onsale:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:background-color',
							'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button:gradient',
		  				'condition' => array( 'id' => 'background_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_hover_shop_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:background',
							'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_hover_shop_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'title' => __('Rating', 'mfn-opts'),
							'class' => 'toggled_header',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating:display',
							'attr_id' => 'shop-list-rating',
							'type' => 'switch',
							'class' => 'mfn-toggled',
							'title' => __('Visibility', 'mfn-opts'),
							'options' => [
								'' => __('Visible', 'mfn-opts'),
								'none' => __('Hidden', 'mfn-opts'),
							],
							'std' => ''
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .star-rating span:color',
							'condition' => array( 'id' => 'shop-list-rating', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			/* END WOO */

				// Divider NEW ------------------------------------------------------

				'divider_2' => array(
   				'type' => 'divider_2',
   				'title' => '&bull; '. __('Divider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
							'id' => 'type',
							'attr_id' => 'divider-2-type',
							'type' => 'select',
							'title' => __('Type', 'mfn-opts'),
							're_render' => true,
							'options' => array(
								'' => 'Empty',

								'#optgroup-border' => 'Border',
									'border-solid' => 'Solid',
									'border-dotted' => 'Dotted',
									'border-dashed' => 'Dashed',
									'border-double' => 'Double',
									// if new added please update conditions below
								'#optgroup-border-end' => '',

								'#optgroup-pattern' => 'Pattern',
									'pattern-star' => 'Star',
									'pattern-triangle' => 'Triangle',
									'pattern-plus' => 'Plus',
									'pattern-tree' => 'Tree',
									'pattern-heart' => 'Heart',
									'pattern-question' => 'Question',
									'pattern-gear' => 'Gear',
									'pattern-parquet' => 'Parquet',
									'pattern-sun' => 'Sun',
									'pattern-fence' => 'Fence',
									'pattern-flower' => 'Flower',
									// if new added please update conditions below
								'#optgroup-pattern-end' => '',

								'#optgroup-lines' => 'Lines',
									'pattern-line-wave' => 'Waves',
									'pattern-line-zigzag' => 'Zig Zag',
									'pattern-line-zigzag2' => 'Zig Zag 2',
									'pattern-line-hearts' => 'Hearts',
									'pattern-line-triangles' => 'Triangles',
									'pattern-line-circles' => 'Circles',
									'pattern-line-circles2' => 'Circles 2',
									'pattern-line-circles3' => 'Circles 3',
									'pattern-line-stars' => 'Stars',
									'pattern-line-rhombus' => 'Rhombus',
									'pattern-line-figures' => 'Figures',
									'pattern-line-loopline' => 'Loopline',
									// if new added please update conditions below
								'#optgroup-lines-end' => '',

							),
							'std' => ''
						),

						array(
							'id' => 'align',
							'type' => 'switch',
							'title' => __('Alignment', 'mfn-opts'),
							're_render' => true,
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
							),
							'std' => 'center',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
						),

						array(
							'id' => 'align_tablet',
							'type' => 'switch',
							'title' => __('Alignment', 'mfn-opts'),
							're_render' => true,
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
						),

						array(
							'id' => 'align_mobile',
							'type' => 'switch',
							'title' => __('Alignment', 'mfn-opts'),
							're_render' => true,
							'options' => array(
								'start' => __('Start', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'end' => __('End', 'mfn-opts'),
								'' => __('Default', 'mfn-opts'),
							),
							'std' => '',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
						),

						// gap

						array(
							'title' => __('Gap', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-top',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap top', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
							'std' => '20px',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-top_tablet',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap top', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-top_mobile',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap top', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-bottom',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap bottom', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
							'std' => '20px',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-bottom_tablet',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap bottom', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-gap-bottom_mobile',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'title' => __('Gap bottom', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '200',
								'step' => '1',
							),
						),

						// addon

						array(
							'title' => __('Addon', 'mfn-opts'),
						),

						array(
							'id' => 'addon',
							'attr_id' => 'divider-2-addon',
							'type' => 'select',
							'title' => __('Addon', 'mfn-opts'),
							're_render' => true,
							'options' => array(
								'' => 'None',
								'label' => 'Label',
								'image' => 'Image',
								'icon' => 'Icon',
							),
							'std' => ''
						),

						array(
							'id' => 'label',
							'type' => 'text',
							'title' => __('Label', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							're_render' => true,
							'std' => ''
						),

						array(
							'id' => 'image',
							'type' => 'upload',
							'title' => __('Image', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'image' ),
							're_render' => true,
							'std' => ''
						),

						array(
							'id' => 'icon',
							'type' => 'icon',
							'title' => __('Icon', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							're_render' => true,
							'std' => ''
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style">',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Container', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:width',
							'type' => 'text',
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'css_attr' => 'width',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:width_tablet',
							'type' => 'text',
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'css_attr' => 'width',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:width_mobile',
							'type' => 'text',
							'default_unit' => 'px',
							'title' => __('Width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'css_attr' => 'width',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Divider', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'isnt', 'val' => '' ),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-height',
							'type' => 'sliderbar',
							'title' => __('Pattern height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'pattern-star,pattern-triangle,pattern-plus,pattern-tree,pattern-heart,pattern-question,pattern-gear,pattern-parquet,pattern-sun,pattern-fence,pattern-flower,pattern-line-wave,pattern-line-zigzag,pattern-line-zigzag2,pattern-line-hearts,pattern-line-triangles,pattern-line-circles,pattern-line-circles2,pattern-line-circles3,pattern-line-stars,pattern-line-rhombus,pattern-line-figures,pattern-line-loopline' ),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '100',
								'step' => '1',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-height_tablet',
							'type' => 'sliderbar',
							'title' => __('Pattern height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'pattern-star,pattern-triangle,pattern-plus,pattern-tree,pattern-heart,pattern-question,pattern-gear,pattern-parquet,pattern-sun,pattern-fence,pattern-flower,pattern-line-wave,pattern-line-zigzag,pattern-line-zigzag2,pattern-line-hearts,pattern-line-triangles,pattern-line-circles,pattern-line-circles2,pattern-line-circles3,pattern-line-stars,pattern-line-rhombus,pattern-line-figures,pattern-line-loopline' ),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '100',
								'step' => '1',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-height_mobile',
							'type' => 'sliderbar',
							'title' => __('Pattern height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'pattern-star,pattern-triangle,pattern-plus,pattern-tree,pattern-heart,pattern-question,pattern-gear,pattern-parquet,pattern-sun,pattern-fence,pattern-flower,pattern-line-wave,pattern-line-zigzag,pattern-line-zigzag2,pattern-line-hearts,pattern-line-triangles,pattern-line-circles,pattern-line-circles2,pattern-line-circles3,pattern-line-stars,pattern-line-rhombus,pattern-line-figures,pattern-line-loopline' ),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '100',
								'step' => '1',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-pattern-color',
							'type' => 'color',
							'title' => __('Pattern color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'pattern-star,pattern-triangle,pattern-plus,pattern-tree,pattern-heart,pattern-question,pattern-gear,pattern-parquet,pattern-sun,pattern-fence,pattern-flower,pattern-line-wave,pattern-line-zigzag,pattern-line-zigzag2,pattern-line-hearts,pattern-line-triangles,pattern-line-circles,pattern-line-circles2,pattern-line-circles3,pattern-line-stars,pattern-line-rhombus,pattern-line-figures,pattern-line-loopline' ),
							'class' => 'mfn-toggled',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-border-width',
							'type' => 'sliderbar',
							'title' => __('Border width', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'border-solid,border-dotted,border-dashed,border-double' ),
							'class' => 'mfn-toggled narrow',
							'param' => array(
								'unit' => 'px',
								'min' => '0',
								'max' => '20',
								'step' => '1',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-border-color',
							'type' => 'color',
							'title' => __('Border color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-type', 'opt' => 'is', 'val' => 'border-solid,border-dotted,border-dashed,border-double' ),
							'class' => 'mfn-toggled',
						),

						array(
							'class' => 'toggled_header',
							'title' => __('Addon', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => '' ),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-spacing',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'title' => __('Spacing', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0, 'max' => 10, 'step' => 0.1),
								'rem' => array('min' => 0, 'max' => 10, 'step' => 0.1),
								'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-spacing_tablet',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'title' => __('Spacing', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0, 'max' => 10, 'step' => 0.1),
								'rem' => array('min' => 0, 'max' => 10, 'step' => 0.1),
								'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-spacing_mobile',
							'type' => 'sliderbar',
							'default_unit' => 'px',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'title' => __('Spacing', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0, 'max' => 10, 'step' => 0.1),
								'rem' => array('min' => 0, 'max' => 10, 'step' => 0.1),
								'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-icon i:font-size',
							'type' => 'sliderbar',
							'title' => __('Icon size', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0, 'max' => 10, 'step' => 0.1),
								'rem' => array('min' => 0, 'max' => 10, 'step' => 0.1),
								'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-icon i:font-size_tablet',
							'type' => 'sliderbar',
							'title' => __('Icon size', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0, 'max' => 10, 'step' => 0.1),
								'rem' => array('min' => 0, 'max' => 10, 'step' => 0.1),
								'vw' 	=> array('min' => 0, 'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-icon i:font-size_mobile',
							'type' => 'sliderbar',
							'title' => __('Icon size', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-icon-color',
							'type' => 'color',
							'title' => __('Icon color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'icon' ),
							'class' => 'mfn-toggled',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-image img:height',
							'type' => 'sliderbar',
							'title' => __('Image height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'image' ),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-image img:height_tablet',
							'type' => 'sliderbar',
							'title' => __('Image height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'image' ),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-image img:height_mobile',
							'type' => 'sliderbar',
							'title' => __('Image height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'image' ),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:color',
							'type' => 'color',
							'title' => __('Text color', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'class' => 'mfn-toggled',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'title' => __('Typography', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'class' => 'mfn-toggled toggle_fields',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:background-color',
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
							'class' => 'mfn-toggled',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-label:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'is', 'val' => 'label' ),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-width',
							'type' => 'sliderbar',
							'title' => __('Width', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-width_tablet',
							'type' => 'sliderbar',
							'title' => __('Width', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-width_mobile',
							'type' => 'sliderbar',
							'title' => __('Width', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-height',
							'type' => 'sliderbar',
							'title' => __('Height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-height_tablet',
							'type' => 'sliderbar',
							'title' => __('Height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner:--mfn-divider-addon-height_mobile',
							'type' => 'sliderbar',
							'title' => __('Height', 'mfn-opts'),
							'condition' => array( 'id' => 'divider-2-addon', 'opt' => 'isnt', 'val' => 'label' ),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled narrow',
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-style',
							'attr_id' => 'divider-2-addon-border',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-color',
							'condition' => array( 'id' => 'divider-2-addon-border', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-width',
		  				'condition' => array( 'id' => 'divider-2-addon-border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'class' => 'mfn-toggled',
		  			),


						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-divider-inner .divider-addon:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'class' => 'mfn-toggled',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

					),
				),

				// Divider Basic -------------------------------------------------------

   			'divider' => array(
   				'type' => 'divider',
   				'title' => '&bull; '. __('Divider Basic', 'mfn-opts'),
   				// 'title' => '&bull; '. __('Divider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'height',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Height', 'mfn-opts'),
							'param' => 'number',
							'class' => 'narrow',
							'after' => 'px',
   					),

   					array(
   						'id' => 'style',
							'attr_id' => 'divider_style',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'default' => __('Default', 'mfn-opts'),
   							'dots' => __('Dots', 'mfn-opts'),
   							'zigzag' => __('ZigZag', 'mfn-opts'),
   						),
							'std' => 'default',
   					),

   					array(
   						'id' => 'line',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Line', 'mfn-opts'),
							'condition' => array( 'id' => 'divider_style', 'opt' => 'is', 'val' => 'default' ),
   						'options' => array(
								'' => __('No line', 'mfn-opts'),
   							'default' => __('Default', 'mfn-opts'),
   							'narrow' => __('Narrow', 'mfn-opts'),
   							'wide' => __('Wide', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'color',
   						'type' => 'color',
   						're_render' => true,
   						'title' => __('Color', 'mfn-opts'),
							'alpha' => true,
   					),

   					array(
   						'id' => 'themecolor',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Theme color', 'mfn-opts'),
   						'desc' => __('Overwrites color selected above', 'mfn-opts'),
   						'options' => array(
   							0 => __('No', 'mfn-opts'),
   							1 => __('Yes', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Placeholder ----------------------------------------------------

   			'placeholder' => array(
   				'type' => 'placeholder',
   				'title' => '&bull; '. __('Placeholder', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'fields' => array(

   					array(
   						'id' => 'info',
   						'type' => 'info',
   						'title' => __('This item has no attributes.', 'mfn-opts'),
   					),

   				),
   			),

   			// Accordion  -----------------------------------------------------

   			'accordion' => array(
   				'type' => 'accordion',
   				'title' => __('Accordion', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'info-key',
   						'type' => 'info',
   						'title' => __('Try the new Toggle element with unlimited customization options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.accordion | h4',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						// tabs

						array(
   						'title' => __('Tabs', 'mfn-opts'),
   					),

   					array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Accordion', 'mfn-opts'),
   						'desc' => __('<b>JavaScript</b> content like Google Maps and some plugins shortcodes do <b>not work</b> in tabs', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									__('Sample tab', 'mfn-opts'),
								],
								'content' => [
									'textarea',
									__('Content', 'mfn-opts'),
									'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'std' => [
								0 => [
									'title' => __('This is the 1st item', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
								1 => [
									'title' => __('This is the 2nd item', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'preview' => 'tabs',
							'primary' => 'title', // default
   					),

   					array(
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
   						'id' => 'icon_active',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						// options

						array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'open1st',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Open first', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default', 'mfn-opts'),
   							1 => __('Open first', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'openAll',
   						're_render' => true,
   						'type' => 'switch',
							'title' => __('Open all', 'mfn-opts'),
   						'options' => array(
								0 => __('Default', 'mfn-opts'),
   							1 => __('Open all', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'accordion' => __('Accordion', 'mfn-opts'),
   							'toggle' => __('Toggle', 'mfn-opts'),
   						),
							'std' => 'accordion',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title bar', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title|before:border-style',
							'attr_id' => 'border_style_accq',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title|before:border-color',
							'condition' => array( 'id' => 'border_style_accq', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-width',
		  				'condition' => array( 'id' => 'border_style_accq', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_accq', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_accq', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title bar icon', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:simple',
   						'title' => __('Question line', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active|after:background-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div></div>',
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Article box  ---------------------------------------------------

   			'article_box' => array(
   				'type' => 'article_box',
   				'title' => __('Article box', 'mfn-opts'),
   				'size' => '1/3',
   				'tablet_size' => '1/3',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>384px - 960px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'slogan',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | p',
   						'edit_tagchild' => 'span',
   						'edit_position' => 'prepend',
   						'title' => __('Slogan', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the slogan', 'mfn-opts'),
							'preview' => 'subtitle',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | h4',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-style',
							'attr_id' => 'border_style_abimg',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-color',
							'condition' => array( 'id' => 'border_style_abimg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-width',
		  				'condition' => array( 'id' => 'border_style_abimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_abimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_abimg', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-style',
							'attr_id' => 'border_style_desc',
							'class' => 'mfn-toggled',
							'type' => 'select',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Slogan', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'desc' => __('Works only with <b>classic style</b>', 'mfn-opts'),
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'class' => 'toggled_header',
   						'title' => __('Decoration', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:--mfn-article-box-decoration',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

   			// Before After  ---------------------------------------------------

   			'before_after' => array(
   				'type' => 'before_after',
   				'title' => __('Before After', 'mfn-opts'),
   				'size' => '1/3',
   				'tablet_size' => '1/3',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						// image

						array(
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
   						'id' => 'image_before',
   						'type' => 'upload',
   						'title' => __('Before', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'image_after',
   						'type' => 'upload',
   						'title' => __('After', 'mfn-opts'),
   						'desc' => __('Both images <b>must have the same size</b>', 'mfn-opts'),
							'std' => $this->get_placeholder(),
   					),

					// label

						array(
   						'title' => __('Label', 'mfn-opts'),
   					),

						array(
		  				'id' => 'label_before',
		  				'type' => 'text',
		  				'title' => __('Before', 'mfn-opts'),
		  			),

						array(
		  				'id' => 'label_after',
		  				'type' => 'text',
		  				'title' => __('After', 'mfn-opts'),
		  			),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Slider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .twentytwenty-wrapper:--mfn-before-after-slider',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Label', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .twentytwenty-wrapper:--mfn-before-after-label',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .twentytwenty-wrapper:--mfn-before-after-label-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blockquote -----------------------------------------------------

   			'blockquote' => array(
   				'type' => 'blockquote',
   				'title' => __('Blockquote', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'used_fonts' => '',
   				'cat' => 'typography',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
   						'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'class' => 'form-content-full-width',
							'editor' => 'basic',
							'preview' => 'content',
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'themeoptions' => 'style:',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'author',
   						'type' => 'text',
   						'edit_tag' => '.blockquote .author | span',
   						'edit_position' => 'append',
   						'title' => __('Author', 'mfn-opts'),
   						'std' => __('This is the author', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon_author',
   						'type' => 'icon',
   						'title' => __('Icon author', 'mfn-opts'),
   					),

						// link

						array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-shadow',
							'type' => 'text_shadow',
							'class' => 'mfn-toggled',
							'title' => __('Text shadow', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'toggle_fields mfn-toggled',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Content icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:font-size',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:font-size_tablet',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:font-size_mobile',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:top',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Top', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:top_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Top', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:top_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Top', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:left',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Left', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:left_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Left', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:left_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Left', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:bottom',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Bottom', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:bottom_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Bottom', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:bottom_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Bottom', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:right',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Right', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:right_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Right', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:right_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Right', 'mfn-opts')
						),


						array(
							'class' => 'toggled_header',
   						'title' => __('Author', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author span,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'toggle_fields mfn-toggled',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Author icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Lines', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-decoration-color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-underline-offset',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Offset', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-decoration-thickness',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Thickness', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blog -----------------------------------------------------------

   			'blog' => array(
   				'type' => 'blog',
   				'title' => __('Blog', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'count',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Posts number', 'mfn-opts'),
   						'std' => '3',
							'after' => 'posts',
							'param' => 'number',
							'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'style',
   						're_render' => true,
   						'type' => 'select',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'classic' => __('Classic - 1 column', 'mfn-opts'),
   							'grid' => __('Grid - 2-4 columns', 'mfn-opts'),
   							'masonry' => __('Masonry blog style - 2-4 columns', 'mfn-opts'),
   							'masonry tiles' => __('Masonry tiles - 2-4 columns', 'mfn-opts'),
   							'photo' => __('Photo - 1 column', 'mfn-opts'),
   							'photo2' => __('Photo 2 - 1-3 columns', 'mfn-opts'),
   							'timeline' => __('Timeline - 1 column', 'mfn-opts'),
   						),
   						'std' => 'grid',
   						'preview' => 'style',
   					),

   					array(
   						'id' => 'columns',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Columns', 'mfn-opts'),
   						'desc' => __('for style: Grid, Masonry, Photo 2', 'mfn-opts'),
   						'options' => array(
   							2	=> 2,
   							3	=> 3,
   							4	=> 4,
   							5	=> 5,
   							6	=> 6,
   						),
   						'std' => 3,
   					),

						array(
   						'id' => 'title_tag',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Title tag', 'mfn-opts'),
   						'options' => array(
   							'h2' => 'H2',
   							'h3' => 'H3',
   							'h4' => 'H4',
   							'h5' => 'H5',
   							'h6' => 'H6',
   						),
   						'std' => 'h2'
   					),

   					array(
   						'id' => 'images',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Post image', 'mfn-opts'),
   						'desc' => __('for all styles except Masonry tiles', 'mfn-opts'),
   						'options' => array(
   							'' => 'Default',
   							'images-only' => 'Featured images only',
   						),
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => true,
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
   						'js_hierarchical_options' => 'blog_categories',
   						'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date'
   					),

   					array(
   						'id' => 'order',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),
   						),
   						'std' => 'DESC'
   					),

						// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'exclude_id',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Exclude posts', 'mfn-opts'),
   						'desc' => __('IDs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
   					),

						array(
   						'id' => 'related',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Use as related posts', 'mfn-opts'),
   						'desc' => __('Exclude current post on single post page. This option will overwrite exclude posts option above.', 'mfn-opts'),
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'filters',
   						're_render' => true,
   						'type' => 'select',
   						'title' => __('Filters', 'mfn-opts'),
   						'desc' => __('for style: Masonry and category: All<br />Does <b>not</b> work with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'0' => __('Hide', 'mfn-opts'),
   							'1' => __('Show', 'mfn-opts'),
   							'only-categories' => __('Show only categories', 'mfn-opts'),
   							'only-tags' => __('Show only tags', 'mfn-opts'),
   							'only-authors' => __('Show only authors', 'mfn-opts'),
   						),
   						'std' => '0'
   					),

						array(
   						'id' => 'excerpt',
   						're_render' => true,
   						'type' => 'switch',
							'title' => __('Excerpt', 'mfn-opts'),
   						'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
							),
   						'std' => 1,
   					),

   					array(
   						'id' => 'more',
   						're_render' => true,
   						'type' => 'switch',
							'title' => __('Read more', 'mfn-opts'),
   						'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
							),
   						'std' => 1,
   					),

						// pagination

   					array(
   						'title' => __('Pagination', 'mfn-opts'),
   					),

   					array(
   						'id' => 'pagination',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Pagination', 'mfn-opts'),
   						'desc' => __('Does <b>not</b> work on WMPL homepage', 'mfn-opts'),
							'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'load_more',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Load more', 'mfn-opts'),
   						'desc' => __('Sliders will be replaced with featured images', 'mfn-opts'),
   						'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// style

   					array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => __('Grayscale', 'mfn-opts'),
							'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'margin',
   						'desc' => __('For style: Masonry tiles', 'mfn-opts'),
   						'type' => 'switch',
   						'title' => __('Margin', 'mfn-opts'),
							'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// plugins

						array(
							'title' => __('Plugins', 'mfn-opts'),
						),

   					array(
   						'id' => 'events',
   						'type' => 'switch',
   						'title' => __('Events', 'mfn-opts'),
   						'desc' => __('for category: All<br />requires free The Events Calendar plugin', 'mfn-opts'),
   						'options' => array(
								0 => __('Exclude', 'mfn-opts'),
   							1 => __('Include', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

   					array(
   						'id' => 'margin',
   						'type' => 'switch',
   						'class' => 'mfn-deprecated',
   						'title' => __('Margin', 'mfn-opts'),
   						'desc' => __('for style: Masonry tiles', 'mfn-opts'),
							'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-style',
							'attr_id' => 'border_style_blog_item',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-color',
							'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-width',
		  				'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-style',
							'attr_id' => 'border_style_blogitem',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_blogitem', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_blogitem', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_blogitem', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_blogitem', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc-wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc-wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc-wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Post header', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head .post-meta:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-style',
							'attr_id' => 'border_style_bloghead',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-color',
							'condition' => array( 'id' => 'border_style_bloghead', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-width',
		  				'condition' => array( 'id' => 'border_style_bloghead', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bloghead', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bloghead', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head .post-meta a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head .post-meta a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Excerpt', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Post footer', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer .button-love a .label:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-style',
							'attr_id' => 'border_style_blogpf',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-color',
							'condition' => array( 'id' => 'border_style_blogpf', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-width',
		  				'condition' => array( 'id' => 'border_style_blogpf', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_blogpf', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_blogpf', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Masonry tiles line', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-title|after:background',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Timeline', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Date color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:--mfn-blog-date-bg',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Date background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item|before:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Dot color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blog News ------------------------------------------------------

   			'blog_news' => array(
   				'type' => 'blog_news',
   				'title' => __('Blog News', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.Latest_news | .title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
   						'id' => 'count',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Posts number', 'mfn-opts'),
   						'std' => '5',
							'after' => 'posts',
							'param' => 'number',
							'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'featured' => __('Featured 1st', 'mfn-opts'),
   						),
							'preview' => 'style',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => true,
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
   						'js_hierarchical_options' => 'blog_categories',
   						'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => true,
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date',
   					),

   					array(
   						'id' => 'order',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),
   						),
   						'std' => 'DESC',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'excerpt',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Excerpt', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   							'featured' => __('Show for featured only', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Button link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link_title',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Button title', 'mfn-opts'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-style',
							'attr_id' => 'border_style_lnp',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-color',
							'condition' => array( 'id' => 'border_style_lnp', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-width',
		  				'condition' => array( 'id' => 'border_style_lnp', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_lnp', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_lnp', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Featured title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4 a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4 a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5 a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5 a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Excerpt', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


		  			array(
							'class' => 'toggled_header',
   						'title' => __('Post footer', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer .button-love a .label:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-style',
							'attr_id' => 'border_style_lndf',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-color',
							'condition' => array( 'id' => 'border_style_lndf', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-width',
		  				'condition' => array( 'id' => 'border_style_lndf', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_lndf', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_lndf', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blog Slider ----------------------------------------------------

   			'blog_slider' => array(
   				'type' => 'blog_slider',
   				'title' => __('Blog Slider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

						array(
   						'id' => 'style',
   						'attr_id' => 'blog_slider_style',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flat' => __('Flat', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'title',
   						'condition' => array( 'id' => 'blog_slider_style', 'opt' => 'is', 'val' => '' ),
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
   						'edit_tag' => '.blog_slider_header | h4.title',
   						'edit_class' => 'title',
   						'edit_position' => 'prepend',
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
   						'id' => 'count',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Posts number', 'mfn-opts'),
   						'std' => '5',
							'after' => 'posts',
							'param' => 'number',
							'class' => 'narrow',
							'preview' => 'number',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
   						'js_hierarchical_options' => 'blog_categories',
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date',
   					),

   					array(
   						'id' => 'order',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),

   						),
   						'std' => 'DESC'
   					),

						// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

						array(
							'id' => 'one_post_per_slide',
							'type' => 'switch',
							're_render' => true,
							'title' => __('One post per slide', 'mfn-opts'),
							'desc' => __('Display single post per slide, instead few of them', 'mfn-opts'),
							'options' => array(
								0 => __('Disable', 'mfn-opts'),
								1 => __('Enable', 'mfn-opts'),
							),
							'std' => 0,
						),

						array(
   						'id' => 'excerpt',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Excerpt', 'mfn-opts'),
   						'options' => array(
								'' => __('Hide', 'mfn-opts'),
   							'1' => __('Show', 'mfn-opts'),

   						),
   						'std' => ''
   					),

   					array(
   						'id' => 'more',
   						'condition' => array( 'id' => 'blog_slider_style', 'opt' => 'is', 'val' => '' ),
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Read more', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
   						'std' => 1,
   					),

   					array(
   						'id' => 'navigation',
   						'condition' => array( 'id' => 'blog_slider_style', 'opt' => 'is', 'val' => '' ),
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Navigation', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'hide-arrows' => __('Hide arrows', 'mfn-opts'),
   							'hide-dots' => __('Hide dots', 'mfn-opts'),
   							'hide-nav' => __('Hide nav', 'mfn-opts'),
   						),
							'std' => '',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-style',
							'attr_id' => 'border_style_bs',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_bs', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_bs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bs', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4 a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Excerpt', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc .post_excerpt:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc .post_excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc .post_excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc .post_excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc .post_excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

























						array(
							'class' => 'toggled_header',
   						'title' => __('Arrows', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-style',
							'attr_id' => 'border_style_bsb',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-width',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button .button_icon i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:border-color',
							'condition' => array( 'id' => 'border_style_bsb', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .blog_slider_header .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),






















						array(
							'class' => 'toggled_header',
   						'title' => __('Date', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper:--mfn-blog-slider-date-bg',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Line', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc hr:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

   			// Blog Teaser ------------------------------------------------------

   			'blog_teaser' => array(
   				'type' => 'blog_teaser',
   				'title' => __('Blog Teaser', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.blog-teaser | .title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'title_tag',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Title tag', 'mfn-opts'),
   						'desc' => __('Title tag for 1st item, others use a smaller one', 'mfn-opts'),
   						'options' => array(
   							'h1' => 'H1',
   							'h2' => 'H2',
   							'h3' => 'H3',
   							'h4' => 'H4',
   							'h5' => 'H5',
   							'h6' => 'H6',
   						),
   						'std' => 'h3'
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						'type' => 'select',
   						're_render' => true,
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
   						'js_hierarchical_options' => 'blog_categories',
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date'
   					),

   					array(
   						'id' => 'order',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),

   						),
   						'std' => 'DESC'
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'margin',
   						'type' => 'switch',
   						're_render' => true,
   						'title' => __('Margin', 'mfn-opts'),
   						'options' => array(
								'0' => __('Disable', 'mfn-opts'),
   							'1' => __('Enable', 'mfn-opts'),
   						),
							'std' => '0'
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-style',
							'attr_id' => 'border_style_tw',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-color',
							'condition' => array( 'id' => 'border_style_tw', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-width',
		  				'condition' => array( 'id' => 'border_style_tw', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_tw', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_tw', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-title a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-title a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Post header', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-style',
							'attr_id' => 'border_style_twpm',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-color',
							'condition' => array( 'id' => 'border_style_twpm', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-width',
		  				'condition' => array( 'id' => 'border_style_twpm', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_twpm', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_twpm', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Line', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser li .desc-wrapper .desc .post-title|after:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Button ----------------------------------------------------

   			'button' => array(
   				'type' => 'button',
   				'title' => __('Button', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'typography',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.button | span.button_label',
   						'edit_position' => 'append',
   						'dynamic_data' => 'title',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('Click here', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'dynamic_data' => 'permalink',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Link target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					// icon

   					array(
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon_position',
   						'type' => 'switch',
   						'title' => __('Position', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'std' => 'left',
   					),

   					// style

   					array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'size',
   						'type' => 'switch',
   						'title' => __('Size', 'mfn-opts'),
   						'options' => array(
   							1 => __('Small', 'mfn-opts'),
   							2 => __('Default', 'mfn-opts'),
   							3 => __('Large', 'mfn-opts'),
   							4 => __('XL', 'mfn-opts'),
   						),
   						'std' => 2,
   					),

   					array(
   						'id' => 'full_width',
   						'type' => 'switch',
   						'title' => __('Width', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default', 'mfn-opts'),
   							1 => __('Full width', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'button_style',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'button_theme' => __('Highlighted', 'mfn-opts'),
   						),
   						'std' => '',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'button_function',
   						'attr_id' => 'button_function',
   						'type' => 'select',
   						'title' => __('Functional button', 'mfn-opts'),
   						'options' => array(
   							'' => __('None', 'mfn-opts'),
   							'exit-mfn-popup' => __('Close popup', 'mfn-opts'),
   							'open-mfn-popup' => __('Open popup', 'mfn-opts'),
   						),
   						'std' => '',
   					),

   					array(
		  				'id' => 'button_function_popupid',
		  				'condition' => array( 'id' => 'button_function', 'opt' => 'is', 'val' => 'open-mfn-popup' ),
		  				'type' => 'text',
		  				'title' => __('Popup ID', 'mfn-opts'),
		  			),

						array(
							'id' => 'class',
							'type' => 'text',
							'title' => __('Class', 'mfn-opts'),
							'desc' => __('This option is useful when you want to use <b>scroll</b>', 'mfn-opts'),
						),

						array(
							'id' => 'button_id',
							'type' => 'text',
							'title' => __('ID', 'mfn-opts'),
							'desc' => __('This option is useful when you want to use <b>GTM</b>', 'mfn-opts'),
						),

						array(
   						'id' => 'download',
   						'type' => 'text',
   						'title' => __('Download', 'mfn-opts'),
   						'desc' => __('Enter the new filename for the downloaded file', 'mfn-opts'),
   					),

   					array(
   						'id' => 'rel',
   						'type' => 'text',
   						'title' => __('Rel', 'mfn-opts'),
   						'before' => 'rel=',
   					),

   					array(
   						'id' => 'onclick',
   						'type' => 'text',
   						'title' => __('Onclick', 'mfn-opts'),
							'before' => 'onclick=',
   					),

						// deprecated

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'align',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Alignment', 'mfn-opts'),
   						'options' => array(
   							'' => __('Left', 'mfn-opts'),
   							'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'std' => '',
							'preview' => 'align',
   					),

   					array(
   						'id' => 'color',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Background color', 'mfn-opts'),
   						'desc' => __('For theme color button please enter <b>theme</b> in color filed', 'mfn-opts'),
   					),

   					array(
   						'id' => 'font_color',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Text color', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-style',
							'attr_id' => 'border_style_button',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-width',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:background-color',
							'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),


						array(
							'form' => 'advanced',
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:transition',
							'type' => 'sliderbar',
							'title' => __('Transition duration', 'mfn-opts'),
							'param' => array(
								'min' => '0',
								'max' => '3',
								'step' => '0.1',
								'unit' => 's',
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),












						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Call to Action -------------------------------------------------

   			'call_to_action' => array(
   				'type' => 'call_to_action',
   				'title' => __('Call to Action', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'title',
   						'edit_tag' => '.call_left | h3',
   						'edit_position' => 'prepend',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'std' => 'icon-check',
   						'preview' => 'icon',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.call_right | div.desc',
   						'edit_position' => 'prepend',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
   						'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

						array(
   						'id' => 'button_title',
   						'type' => 'text',
   						'title' => __('Button title', 'mfn-opts'),
   						'desc' => __('Leave this field blank if you want Call to action with big icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

		  			array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-style',
							'attr_id' => 'border_style_ctaiw',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_ctaiw', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_ctaiw', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_ctaiw', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_ctaiw', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-style',
							'attr_id' => 'border_style_ctab',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-width',
		  				'condition' => array( 'id' => 'border_style_ctab', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_ctab', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_ctab', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher disable-history',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Chart  ---------------------------------------------------------

   			'chart' => array(
   				'type' => 'chart',
   				'title' => __('Chart', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
   						'edit_tag' => '.chart_box | big',
   						'edit_position' => 'append',
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					// chart

   					array(
   						'title' => __('Chart', 'mfn-opts'),
   					),

   					array(
   						'id' => 'percent',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Percent', 'mfn-opts'),
   						'desc' => __('0-100', 'mfn-opts'),
							'param' => 'number',
							'after' => '%',
							'class' => 'narrow',
							'preview' => 'number',
							'std' => 50,
   					),

   					array(
   						'id' => 'label',
   						'type' => 'text',
   						'title' => __('Label', 'mfn-opts'),
							'preview' => 'subtitle',
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
							'std' => 'icon-check',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image size <b>70px x 70px</b>', 'mfn-opts'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .chart-desc:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .chart-desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Label', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .num:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .num:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Style Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Chart', 'mfn-opts'),
   					),

   					array(
   						'id' => 'color',
   						'type' => 'color',
   						're_render' => true,
   						'class' => 'mfn-toggled',
   						'title' => __('Color', 'mfn-opts'),
   						'desc' => __('Overrides color set in Theme Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'line_width',
   						'type' => 'text',
   						'title' => __('Line thickness', 'mfn-opts'),
							'param' => 'number',
							'after' => 'px',
							'class' => 'narrow mfn-toggled',
							'placeholder' => 4,
   					),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Clients  -------------------------------------------------------

   			'clients' => array(
   				'type' => 'clients',
   				'title' => __('Clients', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content active">',
						),

   					array(
   						'id' => 'in_row',
   						'type' => 'text',
   						're_render' => true,
   						'title' => __('Items in row', 'mfn-opts'),
   						'desc' => __('Recommended: 3-6', 'mfn-opts'),
							'after' => 'items',
							'param' => 'number',
							'class' => 'narrow',
   						'std' => 6,
   						'preview' => 'number',
   					),

						array(
   						'id' => 'style',
   						'type' => 'switch',
   						'attr_id' => 'clients_style',
   						're_render' => true,
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'tiles' => __('Tiles', 'mfn-opts'),
   						),
							'std' => '',
							'preview' => 'style',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => true,
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('client-types'),
   						'js_hierarchical_options' => 'client_types',
							'preview' => 'category',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'menu_order'
   					),

   					array(
   						'id' => 'order',
   						're_render' => true,
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),
   						),
   						'std' => 'ASC',
   					),

						// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => 'Grayscale',
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:height',
							'type' => 'text',
							'default_unit' => 'px',
							'class' => 'mfn-toggled',
							'title' => __('Height', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal mfn-tabs-fields-active">',
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper|hover:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Style tiles', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#tilenormal" data-tab="tilenormal">Normal</a></li><li><a href="#tilehover" data-tab="tilehover">Hover</a></li></ul><div class="mfn-sft mfn-sft-tilenormal mfn-tabs-fields-active">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients.clients_tiles:--mfn-clients-tiles',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-tilehover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients.clients_tiles:--mfn-clients-tiles-hover',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Clients Slider -------------------------------------------------

   			'clients_slider' => array(
   				'type' => 'clients_slider',
   				'title' => __('Clients Slider', 'mfn-opts'),
   				'size' =>